/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core;

import java.util.concurrent.ThreadFactory;
import net.sf.appia.core.AppiaError;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Direction;
import net.sf.appia.core.TimeProvider;
import net.sf.appia.core.events.channel.ChannelEvent;
import net.sf.appia.core.events.channel.PeriodicTimer;
import net.sf.appia.core.events.channel.Timer;

public class TimerManager
implements Runnable,
TimeProvider {
    private static final long MICROS = 1000L;
    private boolean alive = false;
    private Thread thread;
    private MyTimer next = null;
    private MyClock clock = new MyClock();

    private synchronized void insert(MyTimer timer) {
        MyTimer prev = null;
        MyTimer t = this.next;
        while (t != null && t.time <= timer.time) {
            prev = t;
            t = t.next;
        }
        if (prev == null) {
            timer.next = this.next;
            this.next = timer;
        } else {
            timer.next = t;
            prev.next = timer;
        }
    }

    private synchronized void remove(String timerID) {
        MyTimer prev = null;
        MyTimer t = this.next;
        while (t != null && !t.id.equals(timerID)) {
            prev = t;
            t = t.next;
        }
        if (t != null) {
            if (prev == null) {
                this.next = t.next;
            } else {
                prev.next = t.next;
            }
        }
    }

    private synchronized MyTimer getNextTimer(long now) {
        if (this.next != null && this.next.time <= now) {
            MyTimer t = this.next;
            this.next = this.next.next;
            return t;
        }
        return null;
    }

    private synchronized void goToSleep(long now) {
        long sleep = this.next != null ? this.next.time - now : this.clock.syncTime;
        if (sleep > 0L) {
            try {
                this.wait(sleep);
                this.clock.update(sleep);
            }
            catch (InterruptedException e) {
                this.clock.sync();
            }
        }
    }

    private synchronized void setAlive(boolean alive) {
        this.alive = alive;
    }

    private synchronized boolean isAlive() {
        return this.alive;
    }

    public TimerManager(ThreadFactory thf) {
        this.thread = thf.newThread(this);
        this.thread.setName("Appia Timer Manager");
        this.thread.setDaemon(true);
    }

    public long nextTimerEvent() {
        return -1L;
    }

    public void handleTimerRequest(Timer timer) {
        int q = timer.getQualifierMode();
        if (q != 2) {
            if (q == 0) {
                this.insert(new MyTimer(timer.timerID, this.currentTimeMillis() + timer.getTimeout(), 0L, timer));
            } else {
                this.remove(timer.timerID);
            }
            this.thread.interrupt();
        }
    }

    public void consumeTimerEvent() {
    }

    public void handlePeriodicTimer(PeriodicTimer timer) {
        int q = timer.getQualifierMode();
        if (q != 2) {
            if (q == 0) {
                long period = timer.getPeriod();
                this.clock.sync();
                this.insert(new MyTimer(timer.timerID, this.currentTimeMillis() + period, period, timer));
            } else {
                this.remove(timer.timerID);
            }
            this.thread.interrupt();
        }
    }

    public void start() {
        this.setAlive(true);
        this.thread.start();
    }

    public void stop() {
        this.setAlive(false);
        this.thread.interrupt();
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        return System.nanoTime() / 1000L;
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            MyTimer timer;
            this.clock.conditionalSync();
            long now = this.clock.read();
            while ((timer = this.getNextTimer(now)) != null) {
                try {
                    ChannelEvent event = timer.period > 0L ? (PeriodicTimer)timer.event.cloneEvent() : timer.event;
                    event.setQualifierMode(2);
                    event.asyncGo(event.getChannel(), Direction.invert(event.getDir()));
                    if (timer.period <= 0L) continue;
                    timer.time = now + timer.period;
                    this.insert(timer);
                }
                catch (AppiaEventException appiaEventException) {
                }
                catch (CloneNotSupportedException e) {
                    throw new AppiaError("TimerManager: CloneNotSupportedException ");
                }
            }
            this.goToSleep(now);
        }
    }

    private class MyClock {
        public final long syncTime = 1000L;
        private long lastSync = 0L;
        private long now = 0L;

        public MyClock() {
            this.sync();
        }

        public synchronized void sync() {
            this.lastSync = this.now = TimerManager.this.currentTimeMillis();
        }

        public synchronized void update(long elapsed) {
            this.now += elapsed;
        }

        public synchronized long read() {
            return this.now;
        }

        public synchronized void conditionalSync() {
            if (this.now > this.lastSync + 1000L) {
                this.lastSync = this.now = TimerManager.this.currentTimeMillis();
            }
        }
    }

    private class MyTimer {
        public String id;
        public long time;
        public long period;
        public ChannelEvent event;
        public MyTimer next;

        public MyTimer(String timerID, long time, long period, ChannelEvent event) {
            this.id = timerID;
            this.time = time;
            this.period = period;
            this.event = event;
        }
    }
}

