/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core.events.channel;

import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.channel.ChannelEvent;

public class Timer
extends ChannelEvent {
    protected static final int DEFAULT_TIMER_PRIORITY = 200;
    public String timerID;
    protected long when;

    public Timer() {
        this.setPriority(200);
    }

    public Timer(String timerID, long when, Channel channel, int dir, Session source, int qualifier) throws AppiaEventException, AppiaException {
        super(channel, dir, source, qualifier);
        this.timerID = timerID;
        this.setPriority(200);
        if (when < 0L) {
            throw new AppiaException("Timer: when is negative");
        }
        this.when = when - channel.getTimeProvider().currentTimeMillis();
    }

    public Timer(long when, String timerID, Channel channel, int dir, Session source, int qualifier) throws AppiaEventException, AppiaException {
        super(channel, dir, source, qualifier);
        this.timerID = timerID;
        this.setPriority(200);
        if (when < 0L) {
            throw new AppiaException("Timer: when is negative");
        }
        this.when = when;
    }

    public void setTimeout(long time) throws AppiaException {
        if (this.when < 0L) {
            throw new AppiaException("Timer: Parameter is negative");
        }
        this.when = time;
    }

    public long getTimeout() {
        return this.when;
    }

    @Override
    public Event cloneEvent() throws CloneNotSupportedException {
        return super.cloneEvent();
    }
}

