/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.core.memoryManager;

import java.io.PrintStream;
import java.security.InvalidParameterException;
import net.sf.appia.core.memoryManager.AppiaWrongSizeException;

public class MemoryManager {
    private static final float NOTIFY_THRESHOLD = 0.9f;
    private PrintStream debugOutput = System.out;
    private String mmID;
    private int maxSize;
    private int currentSize;
    private int upthreshold;
    private int downthreshold;
    private Object downMutex = new Object();
    private Object upMutex = new Object();

    public MemoryManager(String id, int size, int upth, int downth) {
        this.mmID = id;
        this.maxSize = size <= 0 ? 0 : size;
        this.currentSize = 0;
        this.setThreshold(upth, 1);
        this.setThreshold(downth, -1);
    }

    public boolean aboveThreshold(int direction) throws InvalidParameterException {
        if (direction == 1) {
            return this.currentSize >= this.upthreshold;
        }
        if (direction == -1) {
            return this.currentSize >= this.downthreshold;
        }
        throw new InvalidParameterException("Direction must be UP or DOWN in aboveThreshold");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronizedAboveThreshold(int direction) throws InterruptedException, InvalidParameterException {
        boolean above = this.aboveThreshold(direction);
        if (above) {
            Object sync = null;
            sync = direction == 1 ? this.upMutex : this.downMutex;
            Object object = sync;
            synchronized (object) {
                while (above = this.aboveThreshold(direction)) {
                    sync.wait();
                }
            }
        }
        return above;
    }

    public int getThreshold(int direction) throws InvalidParameterException {
        if (direction == 1) {
            return this.upthreshold;
        }
        if (direction == -1) {
            return this.downthreshold;
        }
        throw new InvalidParameterException("Direction must be UP or DOWN in getThreshold.");
    }

    public void setThreshold(int newThreshold, int direction) throws InvalidParameterException {
        if (newThreshold <= 0 || newThreshold > this.maxSize) {
            throw new InvalidParameterException("Invalid threshold on setThreshold.");
        }
        if (direction == 1) {
            this.upthreshold = newThreshold;
        } else if (direction == -1) {
            this.downthreshold = newThreshold;
        } else {
            throw new InvalidParameterException("Direction must be UP or DOWN in setThreshold.");
        }
    }

    public String getMemoryManagerID() {
        return this.mmID;
    }

    public void setMaxSize(int newSize) throws AppiaWrongSizeException {
        if (newSize <= 0 || newSize < this.currentSize) {
            throw new AppiaWrongSizeException("Could not set size of " + this.mmID + " to " + newSize);
        }
        this.maxSize = newSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int used() {
        return this.currentSize;
    }

    public boolean malloc(int nBytes) {
        if (nBytes <= 0) {
            return true;
        }
        if (this.currentSize + nBytes > this.maxSize) {
            return false;
        }
        this.currentSize += nBytes;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(int nBytes) {
        Object object;
        if (nBytes == 0) {
            return;
        }
        if (nBytes < 0 || this.currentSize == 0) {
            return;
        }
        this.currentSize -= Math.min(nBytes, this.currentSize);
        if ((float)this.currentSize <= (float)this.downthreshold * 0.9f) {
            object = this.downMutex;
            synchronized (object) {
                this.downMutex.notifyAll();
            }
        }
        if ((float)this.currentSize <= (float)this.upthreshold * 0.9f) {
            object = this.upMutex;
            synchronized (object) {
                this.upMutex.notifyAll();
            }
        }
    }
}

