/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.management.jmx;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Session;
import net.sf.appia.management.AppiaManagementException;
import net.sf.appia.management.ManagedSession;
import net.sf.appia.management.SensorSessionListener;
import org.apache.log4j.Logger;

public class ChannelManager
extends NotificationBroadcasterSupport
implements DynamicMBean,
SensorSessionListener {
    private static Logger log = Logger.getLogger(ChannelManager.class);
    private static final String LOCALATT_USED_MEMORY = "usedMemory";
    private Channel channel;
    private Map<String, Session> managedSessions;
    private Map<String, Operation<MBeanOperationInfo>> operations;
    private Map<String, Operation<MBeanAttributeInfo>> attributes;
    private MBeanInfo mbeanInfo;
    private ArrayList<MBeanOperationInfo> mboi;
    private ArrayList<MBeanAttributeInfo> mbai;

    public ChannelManager(Channel ch) {
        this.channel = ch;
        this.managedSessions = new Hashtable<String, Session>();
        this.operations = new Hashtable<String, Operation<MBeanOperationInfo>>();
        this.attributes = new Hashtable<String, Operation<MBeanAttributeInfo>>();
        this.mboi = new ArrayList();
        this.mbai = new ArrayList();
        this.mbai.add(new MBeanAttributeInfo(LOCALATT_USED_MEMORY, "gets the memory used by this channel", this.getClass().getName(), true, false, false));
        this.updateMBeanInfo();
    }

    public void addManagedSession(Session s) {
        this.managedSessions.put(s.getId(), s);
        if (s instanceof ManagedSession) {
            MBeanAttributeInfo[] atts;
            ManagedSession ms = (ManagedSession)((Object)s);
            MBeanOperationInfo[] ops = ms.getOperations(s.getId() + ":");
            if (ops != null) {
                for (int i = 0; i < ops.length; ++i) {
                    this.operations.put(ops[i].getName(), new Operation(this, (MBeanFeatureInfo)ops[i], ms));
                    this.mboi.add(ops[i]);
                }
            }
            if ((atts = ms.getAttributes(s.getId() + ":")) != null) {
                for (int i = 0; i < atts.length; ++i) {
                    this.attributes.put(atts[i].getName(), new Operation(this, (MBeanFeatureInfo)atts[i], ms));
                    this.mbai.add(atts[i]);
                }
            }
            this.updateMBeanInfo();
        }
    }

    public Session removeManagedSession(Session s) {
        Session session = this.managedSessions.remove(s.getId());
        if (session instanceof ManagedSession) {
            MBeanAttributeInfo[] atts;
            ManagedSession ms = (ManagedSession)((Object)session);
            MBeanOperationInfo[] ops = ms.getOperations(s.getId() + ":");
            if (ops != null) {
                for (int i = 0; i < ops.length; ++i) {
                    this.operations.remove(ops[i].getName());
                    this.mboi.remove(ops[i]);
                }
            }
            if ((atts = ms.getAttributes(s.getId() + ":")) != null) {
                for (int i = 0; i < atts.length; ++i) {
                    this.attributes.remove(atts[i].getName());
                    this.mbai.remove(atts[i]);
                }
            }
            this.updateMBeanInfo();
        }
        return session;
    }

    @Override
    public void onNotification(Notification notification) {
        notification.setSource(this);
        this.sendNotification(notification);
    }

    public String getChannelName() {
        return this.channel.getChannelID();
    }

    public boolean getStarted() {
        return this.channel.isStarted();
    }

    public int getUsedMemory() {
        if (this.channel.getMemoryManager() == null) {
            return -1;
        }
        return this.channel.getMemoryManager().used();
    }

    @Override
    public Object getAttribute(String att) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET from DynamicMBean: " + att));
        }
        if (att.equals(LOCALATT_USED_MEMORY)) {
            return this.getUsedMemory();
        }
        Operation<MBeanAttributeInfo> op = this.attributes.get(att);
        if (op != null && (((MBeanAttributeInfo)op.operation).isIs() || ((MBeanAttributeInfo)op.operation).isReadable())) {
            try {
                return op.session.attributeGetter(att, (MBeanAttributeInfo)op.operation);
            }
            catch (AppiaManagementException e) {
                throw new MBeanException(e, "unable to invoke operation");
            }
        }
        throw new AttributeNotFoundException("cannot find attribute " + att);
    }

    @Override
    public AttributeList getAttributes(String[] attrs) {
        AttributeList attrList = new AttributeList();
        for (String att : attrs) {
            if (att == null) continue;
            try {
                attrList.add(new Attribute(att, this.getAttribute(att)));
            }
            catch (AttributeNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (MBeanException e1) {
                e1.printStackTrace();
            }
            catch (ReflectionException e1) {
                e1.printStackTrace();
            }
        }
        return attrList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private void updateMBeanInfo() {
        MBeanOperationInfo[] opsArray = new MBeanOperationInfo[this.mboi.size()];
        int i = 0;
        for (MBeanOperationInfo inf : this.mboi) {
            opsArray[i++] = inf;
        }
        MBeanAttributeInfo[] attsArray = new MBeanAttributeInfo[this.mbai.size()];
        i = 0;
        for (MBeanAttributeInfo inf : this.mbai) {
            attsArray[i++] = inf;
        }
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), "Exported operations and attributes list", attsArray, null, opsArray, null);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking: " + actionName + " params " + params.length));
        }
        if (actionName.equals("getAttribute")) {
            try {
                return this.getAttribute((String)params[0]);
            }
            catch (AttributeNotFoundException e1) {
                throw new MBeanException(new AppiaManagementException(e1));
            }
        }
        if (actionName.equals("setAttribute")) {
            System.out.println("WILL CALL SETATTRIBUTE");
            try {
                for (Object obj : params) {
                    System.out.println("### " + obj);
                }
                System.out.println("------------");
                for (String str : signature) {
                    System.out.println("### " + (String)str);
                }
                this.setAttribute((Attribute)params[0]);
            }
            catch (AttributeNotFoundException e) {
                throw new MBeanException(new AppiaManagementException(e));
            }
            catch (InvalidAttributeValueException e) {
                throw new MBeanException(new AppiaManagementException(e));
            }
        } else if (actionName.equals("invoke") && params.length == 3) {
            return this.invoke((String)params[0], (Object[])params[1], (String[])params[2]);
        }
        Operation<MBeanOperationInfo> op = this.operations.get(actionName);
        if (op == null) {
            throw new MBeanException(new AppiaManagementException("Operation " + actionName + " not found."));
        }
        try {
            return op.session.invoke(actionName, (MBeanOperationInfo)op.operation, params, signature);
        }
        catch (AppiaManagementException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute att) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Attribute myAtt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SET from DynamicMBean: " + att.getValue()));
        }
        if ((myAtt = att).getName().equals("Attribute")) {
            myAtt = (Attribute)att.getValue();
        }
        Operation<MBeanAttributeInfo> op = this.attributes.get(myAtt.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("ATT " + myAtt + " Name " + myAtt.getName() + " Value " + myAtt.getValue() + " OP=" + op));
        }
        if (op != null && ((MBeanAttributeInfo)op.operation).isWritable()) {
            try {
                op.session.attributeSetter(myAtt, (MBeanAttributeInfo)op.operation);
            }
            catch (AppiaManagementException e) {
                throw new MBeanException(e, "unable to invoke operation");
            }
        } else {
            throw new AttributeNotFoundException("cannot find attribute " + myAtt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeList setAttributes(AttributeList attList) {
        ListIterator it = attList.listIterator();
        Attribute att = null;
        String[] attrs = new String[attList.size()];
        int i = 0;
        while (it.hasNext()) {
            att = (Attribute)it.next();
            try {
                this.setAttribute(att);
                attrs[i] = att.getName();
            }
            catch (AttributeNotFoundException e) {
                attrs[i] = null;
                e.printStackTrace();
            }
            catch (InvalidAttributeValueException e) {
                attrs[i] = null;
                e.printStackTrace();
            }
            catch (MBeanException e) {
                attrs[i] = null;
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                attrs[i] = null;
                e.printStackTrace();
            }
            finally {
                ++i;
            }
        }
        return this.getAttributes(attrs);
    }

    private static class Operation<T extends MBeanFeatureInfo> {
        T operation;
        ManagedSession session;
        final /* synthetic */ ChannelManager this$0;

        Operation(T op, ManagedSession s) {
            this.this$0 = var1_1;
            this.operation = op;
            this.session = s;
        }
    }
}

