/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.common;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.AppiaException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Session;

public class RegisterSocketEvent
extends Event {
    public static final int FIRST_AVAILABLE = 0;
    public static final int RANDOMLY_AVAILABLE = -1;
    public static final int MEDIA_NOT_AVAILABLE_ERROR = -1;
    public static final int RESOURCE_BUSY_ERROR = -2;
    public static final int RESOURCE_ALREADY_BOUND_ERROR = -3;
    public InetAddress localHost = null;
    public int port;
    public boolean error;
    private int errorCode;
    private String errorDescription;

    public RegisterSocketEvent(Channel channel, int dir, Session source, int port) throws AppiaEventException {
        super(channel, dir, source);
        this.port = port;
        this.error = false;
    }

    public RegisterSocketEvent(Channel channel, int dir, Session source) throws AppiaEventException {
        super(channel, dir, source);
        this.port = 0;
        this.error = false;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public SocketAddress getLocalSocketAddress() throws AppiaException {
        if (this.error) {
            throw new AppiaException("There was an error upon socket registration: Error Code = " + this.errorCode + " Description: " + this.errorDescription);
        }
        if (this.getDir() == -1) {
            throw new AppiaException("Event did not reach the socket session yet!");
        }
        return new InetSocketAddress(this.localHost, this.port);
    }
}

