/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.drop;

import java.io.PrintStream;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.Debug;
import net.sf.appia.protocols.drop.DropLayer;

public class DropSession
extends Session {
    private PrintStream debugOutput = null;
    public static double dropRate = 0.3;

    public DropSession(DropLayer l) {
        super(l);
    }

    public void handle(Event e) {
        if (e instanceof SendableEvent) {
            if (e.getDir() == 1 || Math.random() >= dropRate) {
                try {
                    e.go();
                }
                catch (AppiaEventException ex) {
                    System.err.println("Unexpected exception in Drop Session");
                }
            }
        } else if (e instanceof Debug) {
            this.handleDebug((Debug)e);
        }
    }

    private void handleDebug(Debug e) {
        if (e.getQualifierMode() == 0) {
            this.debugOutput = new PrintStream(e.getOutput());
            this.debugOutput.println("Drop: Debug started");
        } else if (e.getQualifierMode() == 1) {
            this.debugOutput = null;
        } else {
            PrintStream p = new PrintStream(e.getOutput());
            p.println("Drop state dumping:");
            p.println("Drop rate:" + dropRate);
            p.println("Debug output is currently " + (this.debugOutput == null ? "off." : "on."));
        }
    }
}

