/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.fifo;

import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.message.Message;
import net.sf.appia.core.message.MsgBuffer;
import net.sf.appia.protocols.fifo.PeerInfo;
import net.sf.appia.protocols.fifo.WaitingMessage;

public class Header {
    protected boolean mySyn;
    protected boolean hisSyn;
    protected int sequenceNumber;
    protected WaitingMessage waitingMessage;
    protected PeerInfo peer;
    protected static final int INT_SIZE = 4;
    protected static final int HEADER_SIZE = 8;

    public Header(PeerInfo peer, WaitingMessage we) {
        this.mySyn = peer.sendMySyn();
        this.hisSyn = peer.sendSynAck();
        this.sequenceNumber = peer.nextOutgoing;
        this.waitingMessage = we;
        this.peer = peer;
    }

    public void pushHeader(SendableEvent e, int nextIncoming) {
        Message m = e.getMessage();
        MsgBuffer msgBuf = new MsgBuffer();
        msgBuf.len = 8;
        m.push(msgBuf);
        this.seqToByte(msgBuf, this.sequenceNumber, this.mySyn);
        msgBuf.off += 4;
        this.seqToByte(msgBuf, nextIncoming, this.hisSyn);
    }

    public boolean equals(Object o) {
        return o instanceof Header && ((Header)o).mySyn == this.mySyn && ((Header)o).hisSyn == this.hisSyn && ((Header)o).sequenceNumber == this.sequenceNumber && this.peer.peer.equals(((Header)o).peer.peer);
    }

    private void seqToByte(MsgBuffer buf, int seq, boolean syn) {
        buf.data[buf.off + 3] = (byte)((byte)(0xFF & seq >> 24) | (byte)(syn ? 128 : 0));
        buf.data[buf.off + 2] = (byte)(0xFF & seq >> 16);
        buf.data[buf.off + 1] = (byte)(0xFF & seq >> 8);
        buf.data[buf.off] = (byte)(0xFF & seq);
    }
}

