/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.fifounreliable;

import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Set;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.TimeProvider;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.protocols.fifounreliable.PeerInfo;

public class FifoUnreliableSession
extends Session {
    private static final int CLEAN_TIME = 20000;
    private Hashtable peers = new Hashtable();
    private int seqnumber = 0;
    private long refresh;
    private TimeProvider timeProvider = null;

    public FifoUnreliableSession(Layer l) {
        super(l);
    }

    private boolean checkPeerUP(InetSocketAddress id, int seq) {
        PeerInfo peer = (PeerInfo)this.peers.get(id);
        if (peer != null) {
            return peer.testRecSeq(seq);
        }
        peer = new PeerInfo(seq, 1);
        this.peers.put(id, peer);
        return true;
    }

    private void checkPeerDOWN(InetSocketAddress id) {
        PeerInfo peer = (PeerInfo)this.peers.get(id);
        if (peer != null) {
            ++this.seqnumber;
        } else {
            peer = new PeerInfo(0, 1);
            this.peers.put(id, peer);
            ++this.seqnumber;
        }
    }

    private void processOutgoing(SendableEvent e) {
        this.checkPeerDOWN((InetSocketAddress)e.dest);
        e.getMessage().pushInt(this.seqnumber);
        try {
            e.go();
        }
        catch (AppiaEventException appiaEventException) {
            // empty catch block
        }
        this.clean();
    }

    private void processIncoming(SendableEvent e) {
        int seq = e.getMessage().popInt();
        boolean bool = this.checkPeerUP((InetSocketAddress)e.source, seq);
        if (bool) {
            try {
                e.go();
            }
            catch (AppiaEventException appiaEventException) {}
        } else {
            e = null;
        }
        this.clean();
    }

    private void clean() {
        long aux = this.timeProvider.currentTimeMillis();
        if (aux - this.refresh < 20000L) {
            return;
        }
        int size = this.peers.size();
        int counter = 0;
        Set set = this.peers.keySet();
        Object[] obj = set.toArray();
        while (counter < size) {
            if (((PeerInfo)this.peers.get((InetSocketAddress)obj[counter])).getcontrol() == 0) {
                this.peers.remove((InetSocketAddress)obj[counter]);
            } else {
                ((PeerInfo)this.peers.get((InetSocketAddress)obj[counter])).setcontrol(0);
            }
            ++counter;
        }
        this.refresh = this.timeProvider.currentTimeMillis();
    }

    public void handle(Event e) {
        if (e instanceof SendableEvent) {
            this.handleSendable((SendableEvent)e);
        } else {
            if (e instanceof ChannelInit) {
                this.timeProvider = e.getChannel().getTimeProvider();
                this.refresh = this.timeProvider.currentTimeMillis();
            }
            try {
                e.go();
            }
            catch (AppiaEventException appiaEventException) {
                // empty catch block
            }
        }
    }

    private void handleSendable(SendableEvent e) {
        switch (e.getDir()) {
            case 1: {
                this.processIncoming(e);
                break;
            }
            case -1: {
                this.processOutgoing(e);
            }
        }
    }
}

