/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.sslcomplete;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class CustomSSLServerSocketFactory
extends SSLServerSocketFactory {
    private SSLServerSocketFactory sunFactory;
    private String[] anon_cipher_suites = null;
    private boolean anon = false;

    public CustomSSLServerSocketFactory(SSLContext ctx, boolean anon) {
        this.anon = anon;
        this.sunFactory = ctx.getServerSocketFactory();
        if (anon) {
            String[] sunSuites = this.sunFactory.getSupportedCipherSuites();
            String[] aux = new String[sunSuites.length];
            int j = 0;
            for (int i = 0; i < sunSuites.length; ++i) {
                if (sunSuites[i].indexOf("anon") < 0) continue;
                aux[j++] = sunSuites[i];
            }
            this.anon_cipher_suites = new String[j];
            System.arraycopy(aux, 0, this.anon_cipher_suites, 0, j);
        }
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.sunFactory.createServerSocket();
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int param) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.sunFactory.createServerSocket(param);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int param, int param1) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.sunFactory.createServerSocket(param, param1);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int param, int param1, InetAddress inetAddress) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.sunFactory.createServerSocket(param, param1, inetAddress);
        if (this.anon) {
            s.setEnabledCipherSuites(this.anon_cipher_suites);
            s.setNeedClientAuth(false);
        } else {
            s.setNeedClientAuth(true);
        }
        return s;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (this.anon) {
            return this.anon_cipher_suites;
        }
        return this.sunFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sunFactory.getSupportedCipherSuites();
    }
}

