/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.tcpcomplete;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.protocols.tcpcomplete.Measures;
import net.sf.appia.protocols.tcpcomplete.TcpCompleteSession;
import net.sf.appia.protocols.tcpcomplete.TcpUndeliveredEvent;
import net.sf.appia.protocols.utils.ParseUtils;
import org.apache.log4j.Logger;

public class TcpReader
implements Runnable {
    private static Logger log = Logger.getLogger(TcpReader.class);
    private Socket s;
    private InputStream is = null;
    private TcpCompleteSession parentSession;
    private int remotePort;
    private int originalPort;
    private Channel channel;
    private Measures measures;
    private int inactiveCounter = 0;
    private boolean running;

    public TcpReader(Socket socket, TcpCompleteSession session, int originalPort, int remotePort, Channel channel, Measures m) {
        this.s = socket;
        this.parentSession = session;
        this.originalPort = originalPort;
        this.remotePort = remotePort;
        this.channel = channel;
        this.measures = m;
        this.setRunning(true);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        event = null;
        try {
            this.is = this.s.getInputStream();
            if (true) ** GOTO lbl49
        }
        catch (IOException ex) {
            iwp = new InetSocketAddress(this.s.getInetAddress(), this.remotePort);
            if (TcpReader.log.isDebugEnabled()) {
                TcpReader.log.debug((Object)("message reception from " + iwp + " failed. Sending Undelivered event back. Exception:"));
                ex.printStackTrace();
            }
            try {
                undelivered = new TcpUndeliveredEvent(iwp);
                undelivered.asyncGo(this.channel, 1);
                this.parentSession.removeSocket(iwp);
            }
            catch (AppiaEventException exception) {
                TcpReader.log.debug((Object)("Could not insert event: " + exception));
            }
            return;
        }
        do {
            try {
                event = this.receiveAndFormat();
                this.clearInactiveCounter();
                if (event == null) continue;
                if (TcpReader.log.isDebugEnabled()) {
                    TcpReader.log.debug((Object)("received an event. sending it to the appia stack: " + event + " Channel: " + event.getChannel()));
                }
                event.asyncGo(event.getChannel(), 1);
                this.measures.countBytesUp(event.getMessage().length());
                this.measures.countMessagesUp(1);
            }
            catch (AppiaEventException ex) {
                TcpReader.log.debug((Object)("Could not insert event: " + ex));
            }
            catch (SocketTimeoutException ste) {
                TcpReader.log.debug((Object)"TIMEOUT EXCEPTION");
            }
            catch (IOException ex) {
                try {
                    iwp = new InetSocketAddress(this.s.getInetAddress(), this.remotePort);
                    if (TcpReader.log.isDebugEnabled()) {
                        TcpReader.log.debug((Object)("Message reception from " + iwp + " failed. Send undelivered event up."));
                        ex.printStackTrace();
                    }
                    undelivered = new TcpUndeliveredEvent(iwp);
                    undelivered.asyncGo(this.channel, 1);
                    this.parentSession.removeSocket(iwp);
                    this.setRunning(false);
                }
                catch (AppiaEventException e) {
                    if (!TcpReader.log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
            }
lbl49:
            // 8 sources

        } while (this.isRunning());
        try {
            this.s.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int receive_n(byte[] b, int length) throws IOException {
        int n = 0;
        int i = 0;
        int x = 0;
        while (n != length && i != -1) {
            i = this.is.read(b, n, length - n);
            n += i;
            ++x;
        }
        if (i == -1) {
            throw new IOException("Received EOF in the socket input stream.");
        }
        return n;
    }

    private SendableEvent receiveAndFormat() throws IOException {
        Channel msgChannel;
        int sLength;
        int curPos;
        byte[] data;
        int total;
        SendableEvent e;
        block5: {
            e = null;
            byte[] bTotal = new byte[4];
            this.receive_n(bTotal, 4);
            total = ParseUtils.byteArrayToInt(bTotal, 0);
            data = new byte[total];
            this.receive_n(data, total);
            curPos = 0;
            sLength = ParseUtils.byteArrayToInt(data, curPos);
            String className = new String(data, curPos + 4, sLength);
            curPos += sLength + 4;
            e = (SendableEvent)Class.forName(className).newInstance();
            sLength = ParseUtils.byteArrayToInt(data, curPos);
            String channelName = new String(data, curPos + 4, sLength);
            msgChannel = this.parentSession.getChannel(channelName);
            if (msgChannel != null) break block5;
            return null;
        }
        try {
            e.setChannel(msgChannel);
            e.source = new InetSocketAddress(this.s.getInetAddress(), this.remotePort);
            e.dest = new InetSocketAddress(this.s.getLocalAddress(), this.originalPort);
            e.setMessage(msgChannel.getMessageFactory().newMessage(data, curPos += sLength + 4, total - curPos));
        }
        catch (IOException ste) {
            throw ste;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
                log.debug((Object)("Exception catched while processing message from " + this.s.getInetAddress().getHostName() + ":" + this.remotePort + ". Continuing operation."));
            }
            throw new IOException(ex);
        }
        return e;
    }

    public synchronized void setRunning(boolean r) {
        block5: {
            this.running = r;
            if (!this.running && !this.s.isClosed()) {
                try {
                    this.s.close();
                }
                catch (SocketException se) {
                    if (log.isDebugEnabled()) {
                        se.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public Socket getSocket() {
        return this.s;
    }

    public synchronized int getInactiveCounter() {
        return this.inactiveCounter;
    }

    public synchronized int sumInactiveCounter() {
        return ++this.inactiveCounter;
    }

    public synchronized void clearInactiveCounter() {
        this.inactiveCounter = 0;
    }
}

