/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.protocols.udpsimple;

import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.ThreadFactory;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Direction;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.AppiaMulticast;
import net.sf.appia.core.events.SendableEvent;
import net.sf.appia.core.events.channel.ChannelClose;
import net.sf.appia.core.events.channel.ChannelInit;
import net.sf.appia.core.events.channel.Debug;
import net.sf.appia.core.message.Message;
import net.sf.appia.core.message.MsgBuffer;
import net.sf.appia.protocols.common.RegisterSocketEvent;
import net.sf.appia.protocols.common.SendableNotDeliveredEvent;
import net.sf.appia.protocols.frag.MaxPDUSizeEvent;
import net.sf.appia.protocols.udpsimple.MulticastInitEvent;
import net.sf.appia.protocols.utils.HostUtils;
import net.sf.appia.protocols.utils.ParseUtils;
import net.sf.appia.xml.interfaces.InitializableSession;
import net.sf.appia.xml.utils.SessionProperties;
import org.apache.log4j.Logger;

public class UdpSimpleSession
extends Session
implements InitializableSession {
    private static Logger log = Logger.getLogger(UdpSimpleSession.class);
    private static Logger logReader = Logger.getLogger(UdpSimpleReader.class);
    private DatagramSocket sock = null;
    private UdpSimpleReader sockReader = null;
    private HashMap<SocketAddress, UdpSimpleReader> multicastReaders = new HashMap();
    protected HashMap<Integer, Channel> channels = new HashMap();
    private InetAddress param_LOCAL_ADDRESS = null;
    private int param_MAX_UDPMSG_SIZE = 8192;
    private static final int MAX_UdpSimple_HEADERS = 88;
    public static final int DEFAULT_MAX_UDPMSG_SIZE = 8192;
    public static final int DEFAULT_SOTIMEOUT = 5000;
    private int param_SOTIMEOUT = 5000;
    private InetSocketAddress myAddress = null;
    private InetSocketAddress ipMulticast = null;
    private static final boolean debugFull = true;

    public UdpSimpleSession(Layer l) {
        super(l);
        log.debug((Object)"New udpSimple session");
    }

    public void init(SessionProperties params) {
        if (params.containsKey("local_address")) {
            try {
                this.param_LOCAL_ADDRESS = InetAddress.getByName(params.getString("local_address"));
            }
            catch (UnknownHostException e) {
                System.err.println("UDP: Unknown host \"" + params.getString("local_address") + "\". Using default.");
                this.param_LOCAL_ADDRESS = null;
            }
        }
        if (params.containsKey("max_udp_message_size")) {
            this.param_MAX_UDPMSG_SIZE = params.getInt("max_udp_message_size");
        }
        if (params.containsKey("reader_sotimeout")) {
            this.param_SOTIMEOUT = params.getInt("reader_sotimeout");
        }
    }

    public void handle(Event e) {
        if (e instanceof RegisterSocketEvent) {
            this.handleRegisterSocket((RegisterSocketEvent)e);
        } else if (e instanceof SendableEvent) {
            this.handleSendable((SendableEvent)e);
        } else if (e instanceof ChannelInit) {
            this.handleChannelInit((ChannelInit)e);
        } else if (e instanceof ChannelClose) {
            this.handleChannelClose((ChannelClose)e);
        } else if (e instanceof Debug) {
            this.handleDebug((Debug)e);
        } else if (e instanceof MaxPDUSizeEvent) {
            this.handlePDUSize((MaxPDUSizeEvent)e);
        } else if (e instanceof MulticastInitEvent) {
            this.handleMulticastInit((MulticastInitEvent)e);
        } else {
            try {
                log.warn((Object)":handle: Unexpected event. Forwarding it...");
                e.go();
            }
            catch (AppiaEventException appiaEventException) {
                // empty catch block
            }
        }
    }

    private void handlePDUSize(MaxPDUSizeEvent e) {
        log.debug((Object)":handlePDUSize ");
        try {
            e.pduSize = this.param_MAX_UDPMSG_SIZE - 88;
            e.setDir(Direction.invert(e.getDir()));
            e.setSourceSession(this);
            e.init();
            e.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
            System.err.println("Unexpected exception when forwarding MaxPDUSize event in UDPSimple");
        }
    }

    private void handleDebug(Debug e) {
        log.debug((Object)":handleDebug");
        int q = e.getQualifierMode();
        if (q == 0) {
            log.debug((Object)"Ignored Debug event with qualifier ON.");
        } else if (q == 1) {
            log.debug((Object)"Ignored Debug event with qualifier OFF.");
        } else if (q == 2) {
            this.printState(new PrintStream(e.getOutput()));
        }
        try {
            e.go();
        }
        catch (AppiaEventException appiaEventException) {
            // empty catch block
        }
    }

    private void printState(PrintStream out) {
        out.println("UdpSimpleSession state dumping:");
        if (this.sock != null) {
            out.println("Local UDP port: " + this.sock.getLocalPort());
        }
        for (SocketAddress _addr : this.multicastReaders.keySet()) {
            out.println("Local Multicast address: " + _addr);
        }
        int nChannels = this.channels.size();
        out.println("Currently connected channels: " + nChannels);
        for (Channel c : this.channels.values()) {
            out.println("Channel name: " + c.getChannelID() + " QoS: " + c.getQoS().getQoSID());
        }
    }

    private void handleRegisterSocket(RegisterSocketEvent e) {
        log.debug((Object)":handleRegisterSocket");
        if (this.sock != null) {
            this.reverseRegister(e, this.myAddress.getPort(), this.myAddress.getAddress(), true);
            return;
        }
        if (e.localHost != null && !HostUtils.isLocalAddress(e.localHost)) {
            this.reverseRegister(e, e.port, null, true);
            return;
        }
        if (this.newSock(e.port, e.localHost, e.getChannel().getThreadFactory())) {
            this.reverseRegister(e, this.myAddress.getPort(), this.myAddress.getAddress(), false);
        } else {
            this.reverseRegister(e, e.port, null, true);
        }
    }

    private void handleMulticastInit(MulticastInitEvent e) {
        log.debug((Object)":handleAppiaMulticastInit");
        if (!this.multicastReaders.containsKey(e.ipMulticast)) {
            try {
                MulticastSocket multicastSock = new MulticastSocket(((InetSocketAddress)e.ipMulticast).getPort());
                log.debug((Object)(":handleAppiaMulticastInit: Socket Multicast created. Address: " + e.ipMulticast));
                multicastSock.joinGroup(((InetSocketAddress)e.ipMulticast).getAddress());
                this.ipMulticast = new InetSocketAddress(((InetSocketAddress)e.ipMulticast).getAddress(), ((InetSocketAddress)e.ipMulticast).getPort());
                log.debug((Object)":handleAppiaMulticastInit: Socket Multicast joined.");
                try {
                    multicastSock.setSoTimeout(this.param_SOTIMEOUT);
                }
                catch (SocketException se) {
                    System.err.println("Unable to set SoTimeout value on UdpSimpleSession. Using default OS value.");
                    se.printStackTrace();
                }
                UdpSimpleReader multicastReader = new UdpSimpleReader(this, multicastSock, this.ipMulticast, e.fullDuplex ? null : this.myAddress);
                Thread thread = e.getChannel().getThreadFactory().newThread(multicastReader);
                thread.setName("MulticastReaderThread [" + this.ipMulticast + "]");
                multicastReader.setParentThread(thread);
                thread.start();
                this.multicastReaders.put(this.ipMulticast, multicastReader);
                e.error = false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.err.println("Error creating/joining the multicast socket");
                e.error = true;
            }
        } else {
            log.debug((Object)":handleAppiaMulticastInit: Requested multicast socket already existed.");
        }
        try {
            e.setDir(Direction.invert(e.getDir()));
            e.setSourceSession(this);
            e.init();
            e.go();
            log.debug((Object)(":handleAppiaMulticastInit: Returning multicastInit with error code: " + e.error));
            log.debug((Object)(":handleAppiaMulticastInit: Direction is " + (e.getDir() == -1 ? "DOWN" : "UP")));
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    private void handleSendable(SendableEvent e) {
        log.debug((Object)(":handleSendable: " + e));
        if (e.getDir() == -1) {
            this.formatAndSend(e);
        }
        if (e.getChannel().isStarted()) {
            try {
                e.go();
            }
            catch (AppiaEventException ex) {
                System.err.println("Event not initialized but tried to be sent in UdpSimpleSession");
            }
        }
    }

    private void handleChannelInit(ChannelInit e) {
        log.debug((Object)(":handleChannelInit from channel: " + e.getChannel().getChannelID()));
        this.channels.put(new Integer(e.getChannel().getChannelID().hashCode()), e.getChannel());
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            System.err.println("Event not initialized exception in UdpSimpleSession");
        }
    }

    private void handleChannelClose(ChannelClose e) {
        log.debug((Object)(":handleChannelClose: Channel " + e.getChannel().getChannelID() + " closed"));
        this.channels.remove(new Integer(e.getChannel().getChannelID().hashCode()));
        try {
            e.go();
        }
        catch (AppiaEventException ex) {
            System.err.println("Unexpected exception when forwarding ChannelClose event");
        }
        if (this.channels.isEmpty()) {
            this.sockReader.terminate();
            for (UdpSimpleReader _reader : this.multicastReaders.values()) {
                _reader.terminate();
            }
        }
    }

    private boolean newSock(int port, InetAddress addr, ThreadFactory threadFactory) {
        if (addr == null) {
            addr = this.param_LOCAL_ADDRESS == null ? HostUtils.getLocalAddress() : this.param_LOCAL_ADDRESS;
        }
        if (port == 0) {
            try {
                this.sock = new DatagramSocket(0, addr);
            }
            catch (SocketException ex) {
                ex.printStackTrace();
                return false;
            }
        } else if (port == -1) {
            Random random = new Random();
            boolean sucess = false;
            while (!sucess) {
                port = Math.abs(random.nextInt() % Short.MAX_VALUE);
                try {
                    this.sock = new DatagramSocket(port, addr);
                    sucess = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        } else {
            try {
                this.sock = new DatagramSocket(port, addr);
            }
            catch (SocketException se) {
                return false;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        this.myAddress = new InetSocketAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
        try {
            this.sock.setSoTimeout(this.param_SOTIMEOUT);
        }
        catch (SocketException e) {
            System.err.println("Unable to set SoTimeout value on UdpSimpleSession. Using default OS value.");
            e.printStackTrace();
        }
        this.sockReader = new UdpSimpleReader(this, this.sock, this.myAddress);
        Thread t = threadFactory.newThread(this.sockReader);
        t.setName("UdpSimpleReader [" + this.myAddress + "]");
        this.sockReader.setParentThread(t);
        t.start();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void formatAndSend(SendableEvent e) {
        block15: {
            try {
                block17: {
                    block16: {
                        if (this.sock == null && !this.newSock(0, null, e.getChannel().getThreadFactory())) {
                            throw new IOException("Impossible to create new socket.");
                        }
                        msg = e.getMessage();
                        mbuf = new MsgBuffer();
                        eventType = e.getClass().getName().getBytes("ISO-8859-1");
                        channelHash = e.getChannel().getChannelID().hashCode();
                        mbuf.len = 4;
                        msg.push(mbuf);
                        ParseUtils.intToByteArray(channelHash, mbuf.data, mbuf.off);
                        mbuf.len = eventType.length;
                        msg.push(mbuf);
                        System.arraycopy(eventType, 0, mbuf.data, mbuf.off, mbuf.len);
                        mbuf.len = 4;
                        msg.push(mbuf);
                        ParseUtils.intToByteArray(eventType.length, mbuf.data, mbuf.off);
                        if (msg.length() > this.param_MAX_UDPMSG_SIZE) {
                            throw new IOException("Message length to great, may be truncated");
                        }
                        bytes = msg.toByteArray();
                        if (e.dest instanceof AppiaMulticast && ((AppiaMulticast)e.dest).getMulticastAddress() == null) {
                            dests = ((AppiaMulticast)e.dest).getDestinations();
                            if (dests == null) {
                                System.err.println("UdpSimpleSession: Destinations field of AppiaMulticast empty. Not sending event " + e);
                                return;
                            }
                            dp = new DatagramPacket(bytes, bytes.length);
                            i = 0;
                            while (i < dests.length) {
                                if (dests[i] instanceof InetSocketAddress) {
                                    dp.setAddress(((InetSocketAddress)dests[i]).getAddress());
                                    dp.setPort(((InetSocketAddress)dests[i]).getPort());
                                    this.sock.send(dp);
                                    UdpSimpleSession.log.debug((Object)(":formatAndSend: Multicast emulation: " + dp.getLength() + " bytes datagram sent to " + dp.getAddress().getHostAddress() + " (port " + dp.getPort() + ")"));
                                } else {
                                    UdpSimpleSession.log.error((Object)("UdpSimpleSession: Wrong destination address type in event " + e));
                                }
                                ++i;
                            }
                            break block15;
                        }
                        dest = null;
                        if (!(e.dest instanceof InetSocketAddress)) break block16;
                        dest = (InetSocketAddress)e.dest;
                        break block17;
                    }
                    if (!(e.dest instanceof AppiaMulticast)) ** GOTO lbl53
                    aux = ((AppiaMulticast)e.dest).getMulticastAddress();
                    if (aux instanceof InetSocketAddress) {
                        dest = (InetSocketAddress)aux;
                        if (!dest.getAddress().isMulticastAddress()) {
                            System.err.println("UdpSimpleSession: Not a multicast address in AppiaMulticast of event " + e);
                            return;
                        }
                    } else {
                        System.err.println("UdpSimpleSession: Wrong multicast address type in event " + e);
                        return;
lbl53:
                        // 1 sources

                        System.err.println("UdpSimpleSession: Wrong destination address type in event " + e);
                        return;
                    }
                }
                dp = new DatagramPacket(bytes, bytes.length, dest.getAddress(), dest.getPort());
                this.sock.send(dp);
                UdpSimpleSession.log.debug((Object)(":formatAndSend: " + dp.getLength() + " bytes datagram sent to " + dp.getAddress().getHostAddress() + " (port " + dp.getPort() + ")"));
            }
            catch (IOException ex) {
                if (UdpSimpleSession.log.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                try {
                    snd = new SendableNotDeliveredEvent(e.getChannel(), this, e);
                    snd.go();
                    UdpSimpleSession.log.debug((Object)":formatAndSend: IOException when sending Datagram to socket. Inserting SendableNotDeliveredEvent in the channel.");
                }
                catch (AppiaEventException ex1) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void reverseRegister(RegisterSocketEvent e, int port, InetAddress localHost, boolean error) {
        try {
            e.setSourceSession(this);
            e.setDir(Direction.invert(e.getDir()));
            e.port = port;
            e.localHost = localHost;
            e.error = error;
            e.init();
            e.go();
        }
        catch (AppiaEventException ex) {
            ex.printStackTrace();
        }
    }

    class UdpSimpleReader
    implements Runnable {
        private static final int MAX_BUFFER_SIZE = 65536;
        private DatagramSocket sock = null;
        private InetSocketAddress dest = null;
        private InetSocketAddress ignoreSource = null;
        private UdpSimpleSession parentSession = null;
        private Thread parentThread = null;
        private byte[] b = new byte[65536];
        private boolean terminate = false;

        public UdpSimpleReader(UdpSimpleSession parentSession, DatagramSocket s, InetSocketAddress dest) {
            this.parentSession = parentSession;
            this.sock = s;
            this.dest = dest;
        }

        void setParentThread(Thread t) {
            this.parentThread = t;
        }

        public UdpSimpleReader(UdpSimpleSession parentSession, DatagramSocket s, InetSocketAddress dest, InetSocketAddress ignore) {
            this.parentSession = parentSession;
            this.sock = s;
            this.dest = dest;
            this.ignoreSource = ignore;
        }

        public InetSocketAddress getDest() {
            return this.dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            UdpSimpleReader udpSimpleReader = this;
            synchronized (udpSimpleReader) {
                this.terminate = true;
            }
            this.parentThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running = true;
            DatagramPacket msg = new DatagramPacket(this.b, this.b.length);
            logReader.debug((Object)("Reader running (Multicast=" + (this.sock instanceof MulticastSocket) + ")."));
            while (running) {
                try {
                    this.sock.receive(msg);
                    logReader.debug((Object)(":run: PtP datagram received. Size = " + msg.getLength()));
                    if (this.ignoreSource != null && this.ignoreSource.getPort() == msg.getPort() && this.ignoreSource.getAddress().equals(msg.getAddress())) {
                        logReader.debug((Object)":run: Ignored Last received message");
                    } else {
                        this.receiveFormatSend(msg);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException e) {
                    System.err.println("[UdpSimpleSession:reader:run] IOException: " + e.getMessage());
                }
                UdpSimpleReader udpSimpleReader = this;
                synchronized (udpSimpleReader) {
                    if (this.terminate) {
                        running = false;
                    }
                }
            }
        }

        private void receiveFormatSend(DatagramPacket p) {
            block3: {
                byte[] data = new byte[p.getLength()];
                System.arraycopy(p.getData(), p.getOffset(), data, 0, p.getLength());
                SendableEvent e = null;
                Message msg = null;
                try {
                    int sLength = ParseUtils.byteArrayToInt(data, 0);
                    String className = new String(data, 4, sLength, "ISO-8859-1");
                    Class<?> c = Class.forName(className);
                    logReader.debug((Object)(":receiveAndFormat: Reader, creating " + className + " event."));
                    int channelHash = ParseUtils.byteArrayToInt(data, 4 + sLength);
                    Channel msgChannel = this.parentSession.channels.get(new Integer(channelHash));
                    if (msgChannel == null) {
                        logReader.debug((Object)(String.valueOf(this.getClass().getName()) + ": channel does not exist. message will be discarded. " + "hash=" + channelHash));
                        return;
                    }
                    e = (SendableEvent)c.newInstance();
                    e.setMessage(msgChannel.getMessageFactory().newMessage());
                    msg = e.getMessage();
                    msg.setByteArray(data, 8 + sLength, data.length - (8 + sLength));
                    logReader.debug((Object)(":receiveAndFormat: " + msgChannel.getChannelID() + " (" + channelHash + ")"));
                    InetSocketAddress addr = new InetSocketAddress(p.getAddress(), p.getPort());
                    e.source = addr;
                    e.dest = this.dest;
                    e.asyncGo(msgChannel, 1);
                }
                catch (Exception ex) {
                    if (!logReader.isDebugEnabled()) break block3;
                    ex.printStackTrace();
                    logReader.debug((Object)("Exception catched while processing message from " + p.getAddress().getHostName() + ":" + p.getPort() + ". Continued operation."));
                }
            }
        }
    }
}

