/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.xml.templates;

import java.util.Hashtable;
import java.util.LinkedList;
import net.sf.appia.core.AppiaCursorException;
import net.sf.appia.core.AppiaInvalidQoSException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.ChannelCursor;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.Layer;
import net.sf.appia.core.QoS;
import net.sf.appia.core.Session;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.management.jmx.JMXConfiguration;
import net.sf.appia.xml.AppiaXMLException;
import net.sf.appia.xml.interfaces.InitializableSession;
import net.sf.appia.xml.templates.SessionTemplate;
import net.sf.appia.xml.utils.ChannelProperties;
import net.sf.appia.xml.utils.SessionProperties;

public class ChannelTemplate {
    private String name;
    private LinkedList sessionTemplates;

    public ChannelTemplate(String name) {
        this.name = name;
        this.sessionTemplates = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public LinkedList getSessionTemplates() {
        return this.sessionTemplates;
    }

    public void addSession(String name, int sharing, Layer layer) {
        this.sessionTemplates.add(new SessionTemplate(name, sharing, layer));
    }

    public int numberOfLayers() {
        return this.sessionTemplates.size();
    }

    public Channel createChannel(String name, String label, ChannelProperties params, Hashtable globalSessions, Hashtable labelSessions, EventScheduler eventScheduler, MemoryManager memoryManager, JMXConfiguration jmxConfig) throws AppiaXMLException {
        int numberOfSessions = this.sessionTemplates.size();
        Layer[] qosList = new Layer[numberOfSessions];
        SessionTemplate currSession = null;
        for (int i = 0; i < numberOfSessions; ++i) {
            currSession = (SessionTemplate)this.sessionTemplates.get(i);
            qosList[i] = currSession.layerInstance();
        }
        QoS qos = null;
        try {
            qos = new QoS(name + " QoS", qosList);
        }
        catch (AppiaInvalidQoSException e) {
            throw new AppiaXMLException("Unable to create QoS: " + name + " QoS", e);
        }
        Channel channel = eventScheduler == null && memoryManager == null ? qos.createUnboundChannel(name, jmxConfig) : (eventScheduler == null && memoryManager != null ? qos.createUnboundChannel(name, memoryManager, jmxConfig) : (eventScheduler != null && memoryManager == null ? qos.createUnboundChannel(name, eventScheduler, jmxConfig) : qos.createUnboundChannel(name, eventScheduler, memoryManager, jmxConfig)));
        ChannelCursor cc = channel.getCursor();
        cc.bottom();
        for (int i = 0; i < numberOfSessions; ++i) {
            currSession = (SessionTemplate)this.sessionTemplates.get(i);
            Session sessionInstance = null;
            sessionInstance = currSession.getSharingState() == 2 ? currSession.sessionInstance(label, globalSessions) : currSession.sessionInstance(label, labelSessions);
            if (sessionInstance instanceof InitializableSession && params != null && params.containsKey(currSession.getName())) {
                SessionProperties parameters = params.getParams(currSession.getName());
                ((InitializableSession)((Object)sessionInstance)).init(parameters);
            }
            try {
                cc.setSession(sessionInstance);
            }
            catch (AppiaCursorException e) {
                throw new AppiaXMLException("Unable to set the session " + sessionInstance + " on channel " + channel.getChannelID() + ": " + e.getMessage(), e);
            }
            try {
                cc.up();
                continue;
            }
            catch (AppiaCursorException e) {
                throw new AppiaXMLException("Unable to move the cursor up, on channel " + channel.getChannelID() + ".", e);
            }
        }
        return channel;
    }

    public void printChannelTemplate() {
        int i;
        Object[] staux = this.sessionTemplates.toArray();
        SessionTemplate[] st = new SessionTemplate[staux.length];
        for (i = 0; i < staux.length; ++i) {
            st[i] = (SessionTemplate)staux[i];
        }
        System.out.println("Template Name: " + this.name);
        for (i = 0; i < this.sessionTemplates.size(); ++i) {
            st[i].printSessionTemplate();
        }
    }
}

