/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.xml.templates;

import java.util.Hashtable;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;

public class SessionTemplate {
    private String name;
    private int sharing;
    private Layer layerInstance;

    public SessionTemplate(String name, int sharing, Layer layer) {
        this.name = name;
        this.sharing = sharing;
        this.layerInstance = layer;
    }

    public String getName() {
        return this.name;
    }

    public int getSharingState() {
        return this.sharing;
    }

    public Layer layerInstance() {
        return this.layerInstance;
    }

    public Session sessionInstance(String label, Hashtable<String, Session> sharedSessions) {
        Session ns = null;
        if (this.sharing == 0) {
            ns = this.layerInstance.createSession();
            ns.setId(this.name);
            return ns;
        }
        if (this.sharing == 2) {
            if (sharedSessions.containsKey(this.name)) {
                return sharedSessions.get(this.name);
            }
            ns = this.layerInstance.createSession();
            ns.setId(this.name);
            sharedSessions.put(this.name, ns);
            return ns;
        }
        if (sharedSessions.containsKey(this.name + label)) {
            return sharedSessions.get(this.name + label);
        }
        ns = this.layerInstance.createSession();
        ns.setId(this.name);
        sharedSessions.put(this.name + label, ns);
        return ns;
    }

    public void printSessionTemplate() {
        System.out.println("Session name: " + this.name + " (scope: " + this.sharing + ")");
        System.out.println("\tLayer: " + this.layerInstance);
    }
}

