/*
 * Decompiled with CFR 0.152.
 */
package net.sf.appia.xml.utils;

import java.util.LinkedList;
import net.sf.appia.core.EventScheduler;
import net.sf.appia.core.memoryManager.MemoryManager;
import net.sf.appia.xml.utils.ChannelProperties;

public class ChannelInfo {
    private String name;
    private String templateName;
    private String label;
    private ChannelProperties params;
    private boolean initialized;
    private EventScheduler eventScheduler;
    private MemoryManager memoryManager = null;
    private boolean managed;
    private String messageFactory = null;
    private LinkedList dependencies;

    public ChannelInfo(String name, String templateName, String label, ChannelProperties params, boolean initialized, String msgFact) {
        this.name = name;
        this.templateName = templateName;
        this.label = label;
        this.params = params;
        this.initialized = initialized;
        this.messageFactory = msgFact;
        this.dependencies = new LinkedList();
    }

    public ChannelInfo(String name, String templateName, String label, ChannelProperties params, boolean initialized, MemoryManager memoryManager, String msgFact) {
        this.name = name;
        this.templateName = templateName;
        this.label = label;
        this.params = params;
        this.initialized = initialized;
        this.dependencies = new LinkedList();
        this.memoryManager = memoryManager;
        this.messageFactory = msgFact;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChannelProperties getParams() {
        return this.params;
    }

    public void setParams(ChannelProperties params) {
        this.params = params;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public EventScheduler getEventScheduler() {
        return this.eventScheduler;
    }

    public void setEventScheduler(EventScheduler eventScheduler) {
        this.eventScheduler = eventScheduler;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public LinkedList getDependencies() {
        return this.dependencies;
    }

    public void addDependency(ChannelInfo channel) {
        if (!this.dependencies.contains(channel)) {
            this.dependencies.add(channel);
        }
    }

    public boolean depends(ChannelInfo channel) {
        if (this.dependencies.contains(channel)) {
            return true;
        }
        for (int i = 0; i < this.dependencies.size(); ++i) {
            ChannelInfo cinfo = (ChannelInfo)this.dependencies.get(i);
            if (!cinfo.depends(channel)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object arg) {
        if (arg instanceof ChannelInfo) {
            ChannelInfo cinfo = (ChannelInfo)arg;
            return this.name.equals(cinfo.name);
        }
        return false;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public String getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(String messageFactory) {
        this.messageFactory = messageFactory;
    }
}

