/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.process;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.vanilladb.comm.process.ProcessState;

public class CommProcess
implements Serializable {
    private static final long serialVersionUID = 20200318001L;
    private int id;
    private InetSocketAddress address;
    private boolean isSelf;
    private ProcessState state;

    public CommProcess(InetSocketAddress addr, int id, boolean isSelf) {
        this.address = addr;
        this.id = id;
        this.isSelf = isSelf;
        this.state = isSelf ? ProcessState.CORRECT : ProcessState.UNINITIALIZED;
    }

    public CommProcess(CommProcess process) {
        this.address = process.address;
        this.id = process.id;
        this.isSelf = process.isSelf;
        this.state = process.state;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getId() {
        return this.id;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public boolean equals(Object test) {
        if (test == this) {
            return true;
        }
        if (test == null) {
            return false;
        }
        if (!(test instanceof CommProcess)) {
            return false;
        }
        CommProcess proc = (CommProcess)test;
        return this.address.equals(proc.address) && this.id == proc.id;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.address.hashCode();
        hash = hash * 31 + this.id;
        return hash;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public boolean isInitialized() {
        return this.state != ProcessState.UNINITIALIZED;
    }

    public boolean isCorrect() {
        return this.state == ProcessState.CORRECT;
    }
}

