/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.beb;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.process.CommProcess;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.beb.Broadcast;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;

public class BestEffortBroadcastSession
extends Session {
    private static Logger logger = Logger.getLogger(BestEffortBroadcastSession.class.getName());
    private ProcessList processList;

    BestEffortBroadcastSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        } else if (event instanceof Broadcast) {
            this.handleBroadcast((Broadcast)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleBroadcast(Broadcast event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received a Broadcast request");
        }
        try {
            if (event.getDir() == -1) {
                for (int i = 0; i < this.processList.getSize(); ++i) {
                    CommProcess process = this.processList.getProcess(i);
                    if (!process.isCorrect() || process.isSelf()) continue;
                    Broadcast clonedEvent = (Broadcast)event.cloneEvent();
                    clonedEvent.setSourceSession(this);
                    clonedEvent.source = this.processList.getSelfProcess().getAddress();
                    clonedEvent.dest = process.getAddress();
                    clonedEvent.init();
                    clonedEvent.go();
                }
                event.setDir(1);
                event.setSourceSession(this);
                event.source = this.processList.getSelfProcess().getAddress();
                event.dest = this.processList.getSelfProcess().getAddress();
                event.init();
                event.go();
            } else {
                event.go();
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }
}

