/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.floodingconsensus;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Channel;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.floodingconsensus.ConsensusRequest;
import org.vanilladb.comm.protocols.floodingconsensus.ConsensusResult;
import org.vanilladb.comm.protocols.floodingconsensus.Decide;
import org.vanilladb.comm.protocols.floodingconsensus.Propose;
import org.vanilladb.comm.protocols.floodingconsensus.Value;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;

public class FloodingConsensusSession
extends Session {
    private static Logger logger = Logger.getLogger(FloodingConsensusSession.class.getName());
    private ProcessList processList;
    private int roundId = 1;
    private boolean hasDecided = false;
    private List<Set<Value>> proposalsPerRound = new ArrayList<Set<Value>>();
    private List<Set<Integer>> correctsPerRound = new ArrayList<Set<Integer>>();

    FloodingConsensusSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        } else if (event instanceof ConsensusRequest) {
            this.handleConsensusRequest((ConsensusRequest)event);
        } else if (event instanceof Propose) {
            this.handlePropose((Propose)event);
        } else if (event instanceof Decide) {
            this.handleDecide((Decide)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
        this.correctsPerRound.clear();
        this.correctsPerRound.add(this.processList.getCorrectProcessIds());
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleConsensusRequest(ConsensusRequest event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ConsensusRequest");
        }
        this.roundId = 1;
        HashSet<Value> proposal = new HashSet<Value>();
        proposal.add(event.getValue());
        this.propose(event.getChannel(), this.roundId, proposal);
    }

    private void handlePropose(Propose event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received Propose");
        }
        this.includePrposal(event.getRoundId(), event.getProposal());
        int senderPid = this.processList.getId((SocketAddress)event.source);
        this.setCorrect(event.getRoundId(), senderPid);
        this.tryDecide(event.getChannel());
    }

    private void handleDecide(Decide event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received Decide");
        }
        if (!this.hasDecided) {
            this.hasDecided = true;
            this.deliverDecision(event.getChannel(), event.getValue());
            try {
                event.setDir(-1);
                event.setSourceSession(this);
                event.init();
                event.go();
            }
            catch (AppiaEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void propose(Channel channel, int roundId, Set<Value> proposal) {
        try {
            Propose propose = new Propose(channel, this, roundId, proposal);
            propose.init();
            propose.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void includePrposal(int roundId, Set<Value> receivedProposal) {
        while (this.proposalsPerRound.size() < roundId + 1) {
            this.proposalsPerRound.add(new HashSet());
        }
        this.proposalsPerRound.get(roundId).addAll(receivedProposal);
    }

    private void setCorrect(int roundId, int pid) {
        while (this.correctsPerRound.size() < roundId + 1) {
            this.correctsPerRound.add(new HashSet());
        }
        this.correctsPerRound.get(roundId).add(pid);
    }

    private void tryDecide(Channel channel) {
        if (!this.hasDecided && this.correctsPerRound.get(this.roundId).containsAll(this.processList.getCorrectProcessIds())) {
            if (this.correctsPerRound.get(this.roundId).containsAll((Collection)this.correctsPerRound.get(this.roundId - 1))) {
                this.decide(channel);
            } else {
                ++this.roundId;
                this.propose(channel, this.roundId, this.proposalsPerRound.get(this.roundId - 1));
            }
        }
    }

    private void decide(Channel channel) {
        Value decision = (Value)Collections.min((Collection)this.proposalsPerRound.get(this.roundId));
        this.hasDecided = true;
        this.deliverDecision(channel, decision);
        try {
            Decide decide = new Decide(channel, this, decision);
            decide.init();
            decide.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void deliverDecision(Channel channel, Value decision) {
        try {
            ConsensusResult result = new ConsensusResult(channel, this, decision);
            result.init();
            result.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }
}

