/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.p2pcounting;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import net.sf.appia.core.events.SendableEvent;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.protocols.events.ProcessListInit;

public class P2pCountingSession
extends Session {
    private static final long REPORT_PERIOD = 5000L;
    private ProcessList processList;
    private Map<SocketAddress, AtomicInteger> froms = new ConcurrentHashMap<SocketAddress, AtomicInteger>();
    private Map<SocketAddress, AtomicInteger> tos = new ConcurrentHashMap<SocketAddress, AtomicInteger>();
    private Map<String, AtomicInteger> types = new ConcurrentHashMap<String, AtomicInteger>();

    P2pCountingSession(Layer layer) {
        super(layer);
        new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime;
                long lastTime = startTime = System.currentTimeMillis();
                while (true) {
                    long currentTime;
                    if ((currentTime = System.currentTimeMillis()) - lastTime > 5000L) {
                        lastTime = currentTime;
                        double t = (currentTime - startTime) / 1000L;
                        StringBuilder sb = new StringBuilder();
                        sb.append("===================================\n");
                        sb.append(String.format("At %.2f:\n", t));
                        for (int i = 0; i < P2pCountingSession.this.processList.getSize(); ++i) {
                            InetSocketAddress addr = P2pCountingSession.this.processList.getProcess(i).getAddress();
                            sb.append(String.format("From server %d: %d\n", i, ((AtomicInteger)P2pCountingSession.this.froms.get(addr)).getAndSet(0)));
                            sb.append(String.format("To server %d: %d\n", i, ((AtomicInteger)P2pCountingSession.this.tos.get(addr)).getAndSet(0)));
                        }
                        for (String name : P2pCountingSession.this.types.keySet()) {
                            sb.append(String.format("Count for %s: %d\n", name, ((AtomicInteger)P2pCountingSession.this.types.get(name)).getAndSet(0)));
                        }
                        sb.append("===================================\n");
                        System.out.println(sb.toString());
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        } else if (event instanceof SendableEvent) {
            this.handleSendableEvent((SendableEvent)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        this.processList = event.copyProcessList();
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.froms.put(this.processList.getProcess(i).getAddress(), new AtomicInteger());
            this.tos.put(this.processList.getProcess(i).getAddress(), new AtomicInteger());
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleSendableEvent(SendableEvent event) {
        AtomicInteger count;
        if (event.getDir() == 1) {
            SocketAddress from = (SocketAddress)event.source;
            count = this.froms.getOrDefault(from, new AtomicInteger());
            count.incrementAndGet();
        } else {
            SocketAddress to = (SocketAddress)event.dest;
            count = this.tos.getOrDefault(to, new AtomicInteger());
            count.incrementAndGet();
        }
        String name = event.getClass().getSimpleName();
        count = this.types.get(name);
        if (count == null) {
            count = new AtomicInteger(0);
            this.types.put(name, count);
        }
        count.incrementAndGet();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }
}

