/*
 * Decompiled with CFR 0.152.
 */
package org.vanilladb.comm.protocols.zabacceptance;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.appia.core.AppiaEventException;
import net.sf.appia.core.Event;
import net.sf.appia.core.Layer;
import net.sf.appia.core.Session;
import org.vanilladb.comm.process.ProcessList;
import org.vanilladb.comm.process.ProcessState;
import org.vanilladb.comm.protocols.events.ProcessListInit;
import org.vanilladb.comm.protocols.tcpfd.AllProcessesReady;
import org.vanilladb.comm.protocols.tcpfd.FailureDetected;
import org.vanilladb.comm.protocols.zabacceptance.ZabAccept;
import org.vanilladb.comm.protocols.zabacceptance.ZabCacheProposal;
import org.vanilladb.comm.protocols.zabacceptance.ZabDeny;
import org.vanilladb.comm.protocols.zabelection.LeaderChanged;
import org.vanilladb.comm.protocols.zabproposal.ZabProposal;
import org.vanilladb.comm.protocols.zabproposal.ZabProposalId;
import org.vanilladb.comm.protocols.zabproposal.ZabPropose;

public class ZabAcceptanceSession
extends Session {
    private static Logger logger = Logger.getLogger(ZabAcceptanceSession.class.getName());
    private int epochId = 0;
    private long lastReceivedProposalSerial = 0L;
    private ProcessList processList;

    ZabAcceptanceSession(Layer layer) {
        super(layer);
    }

    @Override
    public void handle(Event event) {
        if (event instanceof ProcessListInit) {
            this.handleProcessListInit((ProcessListInit)event);
        }
        if (event instanceof AllProcessesReady) {
            this.handleAllProcessesReady((AllProcessesReady)event);
        } else if (event instanceof FailureDetected) {
            this.handleFailureDetected((FailureDetected)event);
        } else if (event instanceof LeaderChanged) {
            this.handleLeaderChanged((LeaderChanged)event);
        } else if (event instanceof ZabPropose) {
            this.handleZabPropose((ZabPropose)event);
        }
    }

    private void handleProcessListInit(ProcessListInit event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received ProcessListInit");
        }
        this.processList = event.copyProcessList();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleAllProcessesReady(AllProcessesReady event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received AllProcessesReady");
        }
        for (int i = 0; i < this.processList.getSize(); ++i) {
            this.processList.getProcess(i).setState(ProcessState.CORRECT);
        }
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleFailureDetected(FailureDetected event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received FailureDetected (failed id = " + event.getFailedProcessId() + ")");
        }
        this.processList.getProcess(event.getFailedProcessId()).setState(ProcessState.FAILED);
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleLeaderChanged(LeaderChanged event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received LeaderChanged, the new leader is " + event.getNewLeaderId() + ", new epoch " + event.getNewEpochId());
        }
        if (event.getNewEpochId() != this.epochId + 1 && logger.isLoggable(Level.SEVERE)) {
            logger.severe("The epoch id is not as we expected. Do we miss something?");
        }
        this.epochId = event.getNewEpochId();
        try {
            event.go();
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }

    private void handleZabPropose(ZabPropose event) {
        try {
            if (event.getDir() == -1) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Received ZabPropose from application", new Object[0]));
                }
                event.go();
            } else {
                ZabProposal proposal = (ZabProposal)event.getMessage().popObject();
                ZabProposalId id = proposal.getId();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Received ZabPropose from network (epoch id: %d, proposal serial #: %d)", id.getEpochId(), id.getSerialNumber()));
                }
                if (id.getEpochId() == this.epochId && id.getSerialNumber() > this.lastReceivedProposalSerial) {
                    this.lastReceivedProposalSerial = id.getSerialNumber();
                    ZabCacheProposal cache = new ZabCacheProposal(event.getChannel(), this, proposal);
                    cache.init();
                    cache.go();
                    ZabAccept accept = new ZabAccept(event.getChannel(), this);
                    accept.getMessage().pushObject(id);
                    accept.source = this.processList.getSelfProcess().getAddress();
                    accept.dest = event.source;
                    accept.init();
                    accept.go();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("Accept proposal (epoch id: %d, proposal serial #: %d)", id.getEpochId(), id.getSerialNumber()));
                    }
                } else {
                    ZabDeny deny = new ZabDeny(event.getChannel(), this);
                    deny.getMessage().pushObject(id);
                    deny.source = this.processList.getSelfProcess().getAddress();
                    deny.dest = event.source;
                    deny.init();
                    deny.go();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(String.format("Deny proposal (epoch id: %d, proposal serial #: %d)", id.getEpochId(), id.getSerialNumber()));
                    }
                }
            }
        }
        catch (AppiaEventException e) {
            e.printStackTrace();
        }
    }
}

