/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.codegen;

import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.visallo.web.clientapi.ApiInvoker;
import org.visallo.web.clientapi.codegen.ApiException;
import org.visallo.web.clientapi.model.ClientApiUser;
import org.visallo.web.clientapi.model.ClientApiUsers;

public class UserApi {
    protected String basePath = "http://visallo-dev:8889";
    protected ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ClientApiUser getMe() throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        String path = "/user/me".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiUser)ApiInvoker.deserialize(response, "", ClientApiUser.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ClientApiUsers getAll(String q, String workspaceId) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        String path = "/user/all".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(q))) {
            queryParams.put("q", String.valueOf(q));
        }
        if (!"null".equals(String.valueOf(workspaceId))) {
            queryParams.put("workspaceId", String.valueOf(workspaceId));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiUsers)ApiInvoker.deserialize(response, "", ClientApiUsers.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ClientApiUsers getManyByIds(List<String> userIds) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        if (userIds == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/user/all".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String[] contentTypes = new String[]{"multipart/form-data"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            hasFields = true;
            if (userIds != null) {
                for (String userId : userIds) {
                    mp.field("userIds[]", userId, MediaType.MULTIPART_FORM_DATA_TYPE);
                }
            }
            if (hasFields && !mp.getFields().isEmpty()) {
                postBody = mp;
            }
        } else {
            throw new RuntimeException("invalid content type");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiUsers)ApiInvoker.deserialize(response, "", ClientApiUsers.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ClientApiUser getByUserName(String username) throws ApiException {
        String[] contentTypes;
        String contentType;
        FormDataMultiPart postBody = null;
        if (username == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/user".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(username))) {
            queryParams.put("user-name", String.valueOf(username));
        }
        String string = contentType = (contentTypes = new String[]{"application/json"}).length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType);
            if (response != null) {
                return (ClientApiUser)ApiInvoker.deserialize(response, "", ClientApiUser.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

