/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.util.ClientApiConverter;

public class ClientApiWorkspaceDiff
implements ClientApiObject {
    private List<Item> diffs = new ArrayList<Item>();

    public void addAll(List<Item> diffs) {
        this.diffs.addAll(diffs);
    }

    public List<Item> getDiffs() {
        return this.diffs;
    }

    public String toString() {
        return ClientApiConverter.clientApiToString(this);
    }

    public static class PropertyItem
    extends Item {
        private String elementType;
        private String elementId;
        private String elementConcept;
        private String name;
        private String key;
        private String visibilityString;
        @JsonProperty(value="old")
        private JsonNode oldData;
        @JsonProperty(value="new")
        private JsonNode newData;

        public PropertyItem() {
            super("PropertyDiffItem", SandboxStatus.PRIVATE, false);
        }

        public PropertyItem(String elementType, String elementId, String elementConcept, String name, String key, JsonNode oldData, JsonNode newData, SandboxStatus sandboxStatus, boolean deleted, String visibilityString) {
            super("PropertyDiffItem", sandboxStatus, deleted);
            this.elementType = elementType;
            this.elementId = elementId;
            this.elementConcept = elementConcept;
            this.name = name;
            this.key = key;
            this.oldData = oldData;
            this.newData = newData;
            this.visibilityString = visibilityString;
        }

        public String getElementType() {
            return this.elementType;
        }

        public String getElementId() {
            return this.elementId;
        }

        public String getElementConcept() {
            return this.elementConcept;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public JsonNode getOldData() {
            return this.oldData;
        }

        public JsonNode getNewData() {
            return this.newData;
        }

        public String getVisibilityString() {
            return this.visibilityString;
        }
    }

    public static class VertexItem
    extends Item {
        private String vertexId;
        private JsonNode visibilityJson;
        private boolean visible;
        private String title;
        private String conceptType;

        public VertexItem() {
            super("VertexDiffItem", SandboxStatus.PRIVATE, false);
        }

        public VertexItem(String vertexId, String title, String conceptType, JsonNode visibilityJson, SandboxStatus sandboxStatus, boolean deleted, boolean visible) {
            super("VertexDiffItem", sandboxStatus, deleted);
            this.vertexId = vertexId;
            this.visibilityJson = visibilityJson;
            this.visible = visible;
            this.title = title;
            this.conceptType = conceptType;
        }

        public String getVertexId() {
            return this.vertexId;
        }

        public JsonNode getVisibilityJson() {
            return this.visibilityJson;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public String getTitle() {
            return this.title;
        }

        public String getConceptType() {
            return this.conceptType;
        }
    }

    public static class EdgeItem
    extends Item {
        private String edgeId;
        private String label;
        private String outVertexId;
        private String inVertexId;
        private JsonNode visibilityJson;

        public EdgeItem() {
            super("EdgeDiffItem", SandboxStatus.PRIVATE, false);
        }

        public EdgeItem(String edgeId, String label, String outVertexId, String inVertexId, JsonNode visibilityJson, SandboxStatus sandboxStatus, boolean deleted) {
            super("EdgeDiffItem", sandboxStatus, deleted);
            this.edgeId = edgeId;
            this.label = label;
            this.outVertexId = outVertexId;
            this.inVertexId = inVertexId;
            this.visibilityJson = visibilityJson;
        }

        public String getEdgeId() {
            return this.edgeId;
        }

        public String getLabel() {
            return this.label;
        }

        public String getOutVertexId() {
            return this.outVertexId;
        }

        public String getInVertexId() {
            return this.inVertexId;
        }

        public JsonNode getVisibilityJson() {
            return this.visibilityJson;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=VertexItem.class, name="VertexDiffItem"), @JsonSubTypes.Type(value=EdgeItem.class, name="EdgeDiffItem"), @JsonSubTypes.Type(value=PropertyItem.class, name="PropertyDiffItem")})
    public static abstract class Item {
        private final String type;
        private final SandboxStatus sandboxStatus;
        private boolean deleted;

        protected Item(String type, SandboxStatus sandboxStatus, boolean deleted) {
            this.type = type;
            this.sandboxStatus = sandboxStatus;
            this.deleted = deleted;
        }

        public String getType() {
            return this.type;
        }

        public SandboxStatus getSandboxStatus() {
            return this.sandboxStatus;
        }

        public String toString() {
            return ClientApiConverter.clientApiToString(this);
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }
}

