/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.model;

import java.util.Set;
import org.visallo.web.clientapi.model.VisibilityJson;

public enum SandboxStatus {
    PUBLIC,
    PUBLIC_CHANGED,
    PRIVATE;


    public static SandboxStatus getFromVisibilityString(String visibility, String workspaceId) {
        if (visibility == null) {
            return PUBLIC;
        }
        if (workspaceId == null || !visibility.contains(workspaceId)) {
            return PUBLIC;
        }
        return PRIVATE;
    }

    public static SandboxStatus getFromVisibilityJsonString(VisibilityJson visibilityJson, String workspaceId) {
        if (visibilityJson == null) {
            return PUBLIC;
        }
        Set<String> workspacesList = visibilityJson.getWorkspaces();
        if (workspacesList == null || workspacesList.size() == 0) {
            return PUBLIC;
        }
        if (workspaceId == null || !workspacesList.contains(workspaceId)) {
            return PUBLIC;
        }
        return PRIVATE;
    }
}

