/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.clientapi.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.visallo.web.clientapi.model.DirectoryEntity;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.clientapi.util.ObjectMapperFactory;

public class ClientApiConverter {
    public static Object toClientApiValue(Object value) {
        if (value instanceof JSONArray) {
            return ClientApiConverter.toClientApiValue((JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return ClientApiConverter.toClientApiValueInternal((JSONObject)value);
        }
        if (JSONObject.NULL.equals(value)) {
            return null;
        }
        if (value instanceof String) {
            return ClientApiConverter.toClientApiValue((String)value);
        }
        if (value instanceof Date) {
            return ClientApiConverter.toClientApiValue(((Date)value).getTime());
        }
        return value;
    }

    private static List<Object> toClientApiValue(JSONArray json) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < json.length(); ++i) {
            Object obj = json.get(i);
            result.add(ClientApiConverter.toClientApiValue(obj));
        }
        return result;
    }

    private static Object toClientApiValue(String value) {
        try {
            String valueString = value;
            valueString = valueString.trim();
            if (valueString.startsWith("{") && valueString.endsWith("}")) {
                return ClientApiConverter.toClientApiValue((Object)new JSONObject(valueString));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private static Object toClientApiValueInternal(JSONObject json) {
        if (json.length() == 2 && json.has("source") && json.has("workspaces")) {
            VisibilityJson visibilityJson = new VisibilityJson();
            visibilityJson.setSource(json.getString("source"));
            JSONArray workspacesJson = json.getJSONArray("workspaces");
            for (int i = 0; i < workspacesJson.length(); ++i) {
                visibilityJson.addWorkspace(workspacesJson.getString(i));
            }
            return visibilityJson;
        }
        return ClientApiConverter.toClientApiValue(json);
    }

    public static Map<String, Object> toClientApiValue(JSONObject json) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object key : json.keySet()) {
            String keyStr = (String)key;
            result.put(keyStr, ClientApiConverter.toClientApiValue(json.get(keyStr)));
        }
        return result;
    }

    public static Object fromClientApiValue(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (VisibilityJson.isVisibilityJson(map)) {
                return VisibilityJson.fromMap(map);
            }
            if (DirectoryEntity.isEntity(map)) {
                return DirectoryEntity.fromMap(map);
            }
        }
        return obj;
    }

    public static String clientApiToString(Object o) {
        if (o == null) {
            throw new RuntimeException("o cannot be null.");
        }
        try {
            return ObjectMapperFactory.getInstance().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not convert object '" + o.getClass().getName() + "' to string", e);
        }
    }

    public static <T> T toClientApi(String str, Class<T> clazz) {
        try {
            return ObjectMapperFactory.getInstance().readValue(str, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse '" + str + "' to class '" + clazz.getName() + "'", e);
        }
    }
}

