/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.type.GeoPoint;
import org.vertexium.util.IterableUtils;
import org.visallo.common.rdf.RdfTripleImportHelper;
import org.visallo.common.rdf.VisalloRdfTriple;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.DirectVisibilityTranslator;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloDate;
import org.visallo.core.util.VisalloDateTime;
import org.visallo.web.clientapi.model.VisibilityJson;

@RunWith(value=MockitoJUnitRunner.class)
public class RdfTripleImportHelperTest {
    private RdfTripleImportHelper rdfTripleImportHelper;
    private InMemoryGraph graph;
    private Authorizations authorizations;
    private TimeZone timeZone;
    private File workingDir;
    private VisibilityTranslator visibilityTranslator;
    @Mock
    private WorkQueueRepository workQueueRepository;
    @Mock
    private User user;
    private String defaultVisibilitySource;
    private String sourceFileName;

    @Before
    public void setUp() {
        this.graph = InMemoryGraph.create();
        this.workingDir = new File(".");
        this.authorizations = this.graph.createAuthorizations(new String[]{"A"});
        this.timeZone = TimeZone.getDefault();
        this.visibilityTranslator = new DirectVisibilityTranslator();
        Mockito.when((Object)this.user.getUserId()).thenReturn((Object)"user1");
        this.rdfTripleImportHelper = new RdfTripleImportHelper((Graph)this.graph, this.visibilityTranslator, this.workQueueRepository);
        this.defaultVisibilitySource = "";
        this.sourceFileName = "test.nt";
        this.graph.addVertex("v1", new Visibility(""), this.authorizations);
        this.graph.addVertex("v2", new Visibility(""), this.authorizations);
        this.graph.flush();
    }

    @Test
    public void testImportConceptType() {
        String line = "<v1> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://visallo.org/test#type1>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((Object)"http://visallo.org/test#type1", (Object)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)v1));
        Assert.assertNotNull((Object)v1);
    }

    @Test
    public void testImportVertexWithVisibility() {
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        this.graph.deleteVertex(v1, this.authorizations);
        this.graph.flush();
        String line = "<v1[A]> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://visallo.org/test#type1>";
        this.importRdfLine(line);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((Object)new VisalloVisibility("(A)").getVisibility().getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        Assert.assertEquals((Object)"http://visallo.org/test#type1", (Object)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)v1));
        Assert.assertEquals((Object)new VisibilityJson("A"), (Object)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)v1));
        Assert.assertNotNull((Object)v1);
    }

    @Test
    public void testImportProperty() {
        String line = "<v1> <http://visallo.org/test#prop1> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Property property = v1.getProperty(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)"hello world", (Object)property.getValue());
        Assert.assertEquals((Object)new VisalloVisibility("").getVisibility().getVisibilityString(), (Object)property.getVisibility().getVisibilityString());
        Assert.assertEquals((Object)new VisibilityJson(""), (Object)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata()));
    }

    @Test
    public void testImportPropertyWithNonBlankDefaultVisibility() {
        this.defaultVisibilitySource = "A";
        String line = "<v1> <http://visallo.org/test#prop1> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Property property = v1.getProperty(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)"hello world", (Object)property.getValue());
        Assert.assertEquals((Object)new VisalloVisibility("(A)").getVisibility().getVisibilityString(), (Object)property.getVisibility().getVisibilityString());
        Assert.assertEquals((Object)new VisibilityJson("A"), (Object)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata()));
    }

    @Test
    public void testImportPropertyMetadata() {
        this.importRdfLine("<v1> <http://visallo.org/test#prop1> \"hello world\"");
        this.importRdfLine("<v1> <http://visallo.org/test#prop1@metadata\\@1> \"metadata value 1\"");
        this.importRdfLine("<v1> <http://visallo.org/test#prop1@metadata2> \"metadata value 2\"");
        this.importRdfLine("<v1> <http://visallo.org/test#prop1@metadata2[S]> \"metadata value 2 S\"");
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Property prop1 = v1.getProperty(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)"hello world", (Object)prop1.getValue());
        Assert.assertEquals((Object)"metadata value 1", (Object)prop1.getMetadata().getValue("metadata@1"));
        Assert.assertEquals((Object)"metadata value 2", (Object)prop1.getMetadata().getValue("metadata2", new Visibility("")));
        Assert.assertEquals((Object)"metadata value 2 S", (Object)prop1.getMetadata().getValue("metadata2", new Visibility("((S))|visallo")));
    }

    @Test
    public void testImportDateProperty() {
        String line = "<v1> <http://visallo.org/test#prop1> \"2015-05-21\"^^<http://www.w3.org/2001/XMLSchema#date>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Date date = (Date)v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)new VisalloDate(Integer.valueOf(2015), Integer.valueOf(5), Integer.valueOf(21)), (Object)VisalloDate.create((Date)date));
        Assert.assertEquals((String)("Date should be midnight in GMT: " + date), (long)1432166400000L, (long)date.getTime());
    }

    @Test
    public void testImportDateTimeNoTimeZoneProperty() {
        String line = "<v1> <http://visallo.org/test#prop1> \"2015-05-21T08:42:22\"^^<http://www.w3.org/2001/XMLSchema#dateTime>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        VisalloDateTime dateTime = VisalloDateTime.create((Object)v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1"));
        Assert.assertEquals((Object)new VisalloDateTime(Integer.valueOf(2015), Integer.valueOf(5), Integer.valueOf(21), Integer.valueOf(8), Integer.valueOf(42), Integer.valueOf(22), Integer.valueOf(0), TimeZone.getDefault().getID()), (Object)dateTime);
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTimeInMillis(0L);
        cal.set(2015, 4, 21, 8, 42, 22);
        Assert.assertEquals((String)("Time incorrect: " + dateTime.toDate(TimeZone.getDefault())), (long)cal.getTimeInMillis(), (long)dateTime.getEpoch());
    }

    @Test
    public void testImportDateTimeWithGMTTimeZoneProperty() {
        String line = "<v1> <http://visallo.org/test#prop1> \"2015-05-21T08:42:22Z\"^^<http://www.w3.org/2001/XMLSchema#dateTime>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        VisalloDateTime dateTime = VisalloDateTime.create((Object)v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1"));
        Assert.assertEquals((Object)new VisalloDateTime(Integer.valueOf(2015), Integer.valueOf(5), Integer.valueOf(21), Integer.valueOf(8), Integer.valueOf(42), Integer.valueOf(22), Integer.valueOf(0), "GMT"), (Object)dateTime);
        Assert.assertEquals((String)("Time incorrect: " + dateTime.toDateGMT()), (long)1432197742000L, (long)dateTime.getEpoch());
    }

    @Test
    public void testImportDateTimeWithESTTimeZoneProperty() {
        TimeZone tz = TimeZone.getTimeZone("America/Anchorage");
        String timeZoneOffset = "-0" + Math.abs(tz.getOffset(new VisalloDate(Integer.valueOf(2015), Integer.valueOf(4), Integer.valueOf(21)).getEpoch()) / 1000 / 60 / 60) + ":00";
        String line = "<v1> <http://visallo.org/test#prop1> \"2015-05-21T08:42:22" + timeZoneOffset + "\"^^<" + "http://www.w3.org/2001/XMLSchema#dateTime" + ">";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        VisalloDateTime dateTime = VisalloDateTime.create((Object)v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1"));
        Assert.assertEquals((Object)new VisalloDateTime(Integer.valueOf(2015), Integer.valueOf(5), Integer.valueOf(21), Integer.valueOf(8), Integer.valueOf(42), Integer.valueOf(22), Integer.valueOf(0), "America/Anchorage"), (Object)dateTime);
        Assert.assertEquals((String)("Time incorrect: " + dateTime.toDateGMT()), (long)1432226542000L, (long)dateTime.getEpoch());
    }

    @Test
    public void testImportGeoPoint() {
        String line = "<v1> <http://visallo.org/test#prop1> \"Dulles International Airport, VA [38.955589294433594, -77.44930267333984]\"^^<http://visallo.org#geolocation>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        GeoPoint prop1 = (GeoPoint)v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)"Dulles International Airport, VA", (Object)prop1.getDescription());
        Assert.assertEquals((double)38.95559f, (double)prop1.getLatitude(), (double)1.0E-5);
        Assert.assertEquals((double)-77.4493f, (double)prop1.getLongitude(), (double)1.0E-5);
    }

    @Test
    public void testImportDirectoryEntity() {
        String line = "<v1> <http://visallo.org/test#prop1> \"joe\"^^<http://visallo.org#directory/entity>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        String prop1 = (String)v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)"joe", (Object)prop1);
    }

    @Test
    public void testImportPropertyWithKey() {
        String line = "<v1> <http://visallo.org/test#prop1:key1> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((Object)"hello world", (Object)v1.getPropertyValue("key1", "http://visallo.org/test#prop1"));
    }

    @Test
    public void testImportPropertyWithKeyThatHasAColon() {
        String line = "<v1> <http://visallo.org/test#prop1:key\\:1> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((Object)"hello world", (Object)v1.getPropertyValue("key:1", "http://visallo.org/test#prop1"));
    }

    @Test
    public void testImportPropertyVisibility() {
        String line = "<v1> <http://visallo.org/test#prop1[A]> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Property property = v1.getProperty("http://visallo.org/test#prop1");
        Assert.assertNotNull((String)"Could not find property", (Object)property);
        Assert.assertEquals((Object)"hello world", (Object)property.getValue());
        Assert.assertEquals((Object)new VisalloVisibility("(A)").getVisibility().getVisibilityString(), (Object)property.getVisibility().getVisibilityString());
        Assert.assertEquals((Object)new VisibilityJson("A"), (Object)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata()));
    }

    @Test
    public void testImportPropertyVisibilityAndKey() {
        String line = "<v1> <http://visallo.org/test#prop1:key1[A]> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Property property = v1.getProperty("key1", "http://visallo.org/test#prop1");
        Assert.assertNotNull((String)"Could not find property with key", (Object)property);
        Assert.assertEquals((Object)"hello world", (Object)property.getValue());
        Assert.assertEquals((Object)new VisalloVisibility("(A)").getVisibility().getVisibilityString(), (Object)property.getVisibility().getVisibilityString());
        Assert.assertEquals((Object)new VisibilityJson("A"), (Object)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata()));
    }

    @Test
    public void testImportStreamingPropertyValue() throws IOException {
        File file = File.createTempFile(RdfTripleImportHelperTest.class.getName(), "txt");
        file.deleteOnExit();
        FileUtils.writeStringToFile((File)file, (String)"hello world");
        String line = "<v1> <http://visallo.org/test#prop1> \"" + file.getAbsolutePath() + "\"^^<" + "http://visallo.org#streamingPropertyValue" + ">";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Object propertyValue = v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertTrue((boolean)(propertyValue instanceof StreamingPropertyValue));
        Assert.assertEquals((Object)"hello world", (Object)IOUtils.toString((InputStream)((StreamingPropertyValue)propertyValue).getInputStream()));
    }

    @Test
    public void testImportStreamingPropertyValueInline() throws IOException {
        String line = "<v1> <http://visallo.org/test#prop1> \"hello world\"^^<http://visallo.org#streamingPropertyValueInline>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Object propertyValue = v1.getPropertyValue(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertTrue((boolean)(propertyValue instanceof StreamingPropertyValue));
        Assert.assertEquals((Object)"hello world", (Object)IOUtils.toString((InputStream)((StreamingPropertyValue)propertyValue).getInputStream()));
    }

    @Test
    public void testImportEdge() {
        String line = "<v1> <http://visallo.org/test#edgeLabel1> <v2>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((long)1L, (long)v1.getEdgeCount(Direction.OUT, this.authorizations));
        List edges = IterableUtils.toList((Iterable)v1.getEdges(Direction.OUT, this.authorizations));
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)"http://visallo.org/test#edgeLabel1", (Object)((Edge)edges.get(0)).getLabel());
        Assert.assertEquals((Object)"v2", (Object)((Edge)edges.get(0)).getOtherVertex("v1", this.authorizations).getId());
    }

    @Test
    public void testImportEdgeWithVisibility() {
        String line = "<v1> <http://visallo.org/test#edgeLabel1[A]> <v2>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((long)1L, (long)v1.getEdgeCount(Direction.OUT, this.authorizations));
        List edges = IterableUtils.toList((Iterable)v1.getEdges(Direction.OUT, this.authorizations));
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)new VisalloVisibility("(A)").getVisibility().getVisibilityString(), (Object)((Edge)edges.get(0)).getVisibility().getVisibilityString());
        Assert.assertEquals((Object)"http://visallo.org/test#edgeLabel1", (Object)((Edge)edges.get(0)).getLabel());
        Assert.assertEquals((Object)"v2", (Object)((Edge)edges.get(0)).getOtherVertex("v1", this.authorizations).getId());
    }

    @Test
    public void testImportEdgeWithId() {
        String line = "<v1> <http://visallo.org/test#edgeLabel1:edge1> <v2>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((long)1L, (long)v1.getEdgeCount(Direction.OUT, this.authorizations));
        List edges = IterableUtils.toList((Iterable)v1.getEdges(Direction.OUT, this.authorizations));
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)"http://visallo.org/test#edgeLabel1", (Object)((Edge)edges.get(0)).getLabel());
        Assert.assertEquals((Object)"v2", (Object)((Edge)edges.get(0)).getOtherVertex("v1", this.authorizations).getId());
        Assert.assertEquals((Object)"edge1", (Object)((Edge)edges.get(0)).getId());
    }

    @Test
    public void testImportEdgeWithIdWithAColon() {
        String line = "<v1> <http://visallo.org/test#edgeLabel1:edge\\:1> <v2>";
        this.importRdfLine(line);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.authorizations);
        Assert.assertEquals((long)1L, (long)v1.getEdgeCount(Direction.OUT, this.authorizations));
        List edges = IterableUtils.toList((Iterable)v1.getEdges(Direction.OUT, this.authorizations));
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)"http://visallo.org/test#edgeLabel1", (Object)((Edge)edges.get(0)).getLabel());
        Assert.assertEquals((Object)"v2", (Object)((Edge)edges.get(0)).getOtherVertex("v1", this.authorizations).getId());
        Assert.assertEquals((Object)"edge:1", (Object)((Edge)edges.get(0)).getId());
    }

    @Test
    public void testImportEdgeProperty() {
        this.graph.addEdge("edge1", "v1", "v2", "label1", new Visibility(""), this.authorizations);
        String line = "<EDGE:edge1> <http://visallo.org/test#prop1> \"hello world\"";
        this.importRdfLine(line);
        this.graph.flush();
        Edge edge1 = this.graph.getEdge("edge1", this.authorizations);
        Property property = edge1.getProperty(VisalloRdfTriple.MULTI_KEY, "http://visallo.org/test#prop1");
        Assert.assertEquals((Object)"hello world", (Object)property.getValue());
        Assert.assertEquals((Object)new VisalloVisibility("").getVisibility().getVisibilityString(), (Object)property.getVisibility().getVisibilityString());
        Assert.assertEquals((Object)new VisibilityJson(""), (Object)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata()));
    }

    private void importRdfLine(String line) {
        HashSet elements = new HashSet();
        this.rdfTripleImportHelper.importRdfLine(elements, this.sourceFileName, line, this.workingDir, this.timeZone, this.defaultVisibilitySource, this.user, this.authorizations);
    }
}

