/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.junit.Test;
import org.vertexium.DateOnly;
import org.vertexium.ElementType;
import org.vertexium.type.GeoPoint;
import org.visallo.common.rdf.SetPropertyVisalloRdfTriple;
import org.visallo.common.rdf.VisalloRdfTriple;
import org.visallo.common.rdf.VisalloRdfTripleTestBase;
import org.visallo.web.clientapi.model.DirectoryPerson;

public class SetPropertyVisalloRdfTripleTest
extends VisalloRdfTripleTestBase {
    @Test
    public void testToStringVertex() {
        SetPropertyVisalloRdfTriple triple = new SetPropertyVisalloRdfTriple(ElementType.VERTEX, "v1", "A", "pkey", "http://visallo.org#pname", "B", (Object)"value1");
        this.assertEqualsVisalloRdfTriple("<v1[A]> <http://visallo.org#pname:pkey[B]> \"value1\"", (VisalloRdfTriple)triple);
    }

    @Test
    public void testToStringVertexWithPropertyKeyThatHasAColon() {
        SetPropertyVisalloRdfTriple triple = new SetPropertyVisalloRdfTriple(ElementType.VERTEX, "v1", "A", "pkey:1", "http://visallo.org#pname", "B", (Object)"value1");
        this.assertEqualsVisalloRdfTriple("<v1[A]> <http://visallo.org#pname:pkey\\:1[B]> \"value1\"", (VisalloRdfTriple)triple);
    }

    @Test
    public void testToStringEdge() {
        SetPropertyVisalloRdfTriple triple = new SetPropertyVisalloRdfTriple(ElementType.EDGE, "e1", "A", "pkey", "http://visallo.org#pname", "B", (Object)"value1");
        this.assertEqualsVisalloRdfTriple("<EDGE:e1[A]> <http://visallo.org#pname:pkey[B]> \"value1\"", (VisalloRdfTriple)triple);
    }

    @Test
    public void testStringValue() {
        this.testValue("value1", "\"value1\"");
    }

    @Test
    public void testIntegerValue() {
        this.testValue(42, "\"42\"^^<http://www.w3.org/2001/XMLSchema#int>");
    }

    @Test
    public void testDoubleValue() {
        this.testValue(42.2, "\"42.2\"^^<http://www.w3.org/2001/XMLSchema#double>");
    }

    @Test
    public void testBooleanValue() {
        this.testValue(true, "\"true\"^^<http://www.w3.org/2001/XMLSchema#boolean>");
    }

    @Test
    public void testGeoLocationValue() {
        this.testValue(new GeoPoint(42.2, 54.6), "\"42.2, 54.6\"^^<http://visallo.org#geolocation>");
    }

    @Test
    public void testDateTimeValue() {
        Date date = Date.from(LocalDateTime.of(2016, 5, 19, 1, 46, 28).atZone(ZoneId.of("GMT")).toInstant());
        this.testValue(date, "\"2016-05-19T01:46:28Z\"^^<http://www.w3.org/2001/XMLSchema#dateTime>");
    }

    @Test
    public void testDirectoryEntryValue() {
        this.testValue(new DirectoryPerson("jferner", "Joe Ferner"), "\"jferner\"^^<http://visallo.org#directory/entity>", false);
    }

    @Test
    public void testDateValue() {
        this.testValue(new DateOnly(2016, 5, 19), "\"2016-06-19\"^^<http://www.w3.org/2001/XMLSchema#date>", false);
    }

    private void testValue(Object value, String expected) {
        this.testValue(value, expected, true);
    }

    private void testValue(Object value, String expected, boolean assertRoundTrip) {
        SetPropertyVisalloRdfTriple triple = new SetPropertyVisalloRdfTriple(ElementType.VERTEX, "v1", "A", "pkey", "http://visallo.org#pname", "B", value);
        String expectedString = "<v1[A]> <http://visallo.org#pname:pkey[B]> " + expected;
        this.assertEqualsVisalloRdfTriple(expectedString, (VisalloRdfTriple)triple, assertRoundTrip);
    }
}

