/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.common.rdf.AddEdgeVisalloRdfTriple;
import org.visallo.common.rdf.ConceptTypeVisalloRdfTriple;
import org.visallo.common.rdf.ImportContext;
import org.visallo.common.rdf.PropertyVisalloRdfTriple;
import org.visallo.common.rdf.RdfTriple;
import org.visallo.common.rdf.RdfTripleParser;
import org.visallo.common.rdf.SetMetadataVisalloRdfTriple;
import org.visallo.common.rdf.VisalloRdfTriple;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.security.VisalloVisibility;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.status.MetricsManager;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.VisibilityJson;

public class RdfTripleImportHelper {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(RdfTripleImportHelper.class);
    private static final String MULTIVALUE_KEY = RdfTripleImportHelper.class.getName();
    private final Graph graph;
    private final VisibilityTranslator visibilityTranslator;
    private WorkQueueRepository workQueueRepository;
    private final MetricsManager metricsManager;
    private static final Map<String, Visibility> visibilityCache = new HashMap<String, Visibility>();
    private boolean failOnFirstError = false;

    public void setFailOnFirstError(boolean failOnFirstError) {
        this.failOnFirstError = failOnFirstError;
    }

    @Inject
    public RdfTripleImportHelper(Graph graph, VisibilityTranslator visibilityTranslator, WorkQueueRepository workQueueRepository, MetricsManager metricsManager) {
        this.graph = graph;
        this.visibilityTranslator = visibilityTranslator;
        this.workQueueRepository = workQueueRepository;
        this.metricsManager = metricsManager;
    }

    @Deprecated
    public void importRdfTriple(File inputFile, TimeZone timeZone, String defaultVisibilitySource, User user, Authorizations authorizations) throws IOException {
        this.importRdfTriple(inputFile.getName(), new FileInputStream(inputFile), inputFile.getParentFile(), timeZone, Priority.NORMAL, defaultVisibilitySource, user, authorizations);
    }

    public void importRdfTriple(File inputFile, TimeZone timeZone, Priority priority, String defaultVisibilitySource, User user, Authorizations authorizations) throws IOException {
        this.importRdfTriple(inputFile.getName(), new FileInputStream(inputFile), inputFile.getParentFile(), timeZone, priority, defaultVisibilitySource, user, authorizations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importRdfTriple(String sourceFileName, InputStream inputStream, File workingDir, TimeZone timeZone, Priority priority, String defaultVisibilitySource, User user, Authorizations authorizations) throws IOException {
        long startTime = System.currentTimeMillis();
        HashSet<Element> elements = new HashSet<Element>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        int lineNum = 1;
        ImportContext ctx = null;
        String timerMetricName = this.metricsManager.getNamePrefix((Object)this);
        Timer timer = this.metricsManager.timer(timerMetricName);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.debug("Importing RDF triple on line: %d. Rate: %.2f / sec", new Object[]{lineNum, timer.getMeanRate()});
                try (Timer.Context timerContext = timer.time();){
                    ctx = this.importRdfLine(ctx, elements, sourceFileName, line, workingDir, timeZone, defaultVisibilitySource, user, authorizations);
                }
                catch (Exception e) {
                    String errMsg = String.format("Error importing RDF triple on line: %d. %s", lineNum, e.getMessage());
                    if (this.failOnFirstError) {
                        throw new VisalloException(errMsg);
                    }
                    LOGGER.error(errMsg, (Throwable)e);
                }
                ++lineNum;
            }
            if (ctx != null) {
                elements.add(ctx.save(authorizations));
            }
        }
        finally {
            this.metricsManager.removeMetric(timerMetricName);
        }
        this.graph.flush();
        LOGGER.info("pushing %d elements from RDF import on to work queue", new Object[]{elements.size()});
        this.workQueueRepository.pushElements(elements, priority);
        long endTime = System.currentTimeMillis();
        LOGGER.debug("RDF %s imported in %dms", new Object[]{sourceFileName, endTime - startTime});
    }

    @VisibleForTesting
    ImportContext importRdfLine(ImportContext ctx, Set<Element> elements, String sourceFileName, String line, File workingDir, TimeZone timeZone, String defaultVisibilitySource, User user, Authorizations authorizations) {
        if (line.length() == 0 || line.charAt(0) == '#') {
            return ctx;
        }
        RdfTriple rdfTriple = RdfTripleParser.parseLine(line);
        return this.importRdfTriple(ctx, elements, rdfTriple, sourceFileName, workingDir, timeZone, defaultVisibilitySource, user, authorizations);
    }

    private ImportContext importRdfTriple(ImportContext ctx, Set<Element> elements, RdfTriple rdfTriple, String sourceFileName, File workingDir, TimeZone timeZone, String defaultVisibilitySource, User user, Authorizations authorizations) {
        if (!(rdfTriple.getFirst() instanceof RdfTriple.UriPart)) {
            throw new VisalloException("Unhandled combination of RDF triples. First triple expected to be a URI, but was " + rdfTriple.getFirst().getClass().getName());
        }
        if (!(rdfTriple.getSecond() instanceof RdfTriple.UriPart)) {
            throw new VisalloException("Unhandled combination of RDF triples. Second triple expected to be a URI, but was " + rdfTriple.getFirst().getClass().getName());
        }
        VisalloRdfTriple triple = VisalloRdfTriple.parse(rdfTriple, defaultVisibilitySource, workingDir, timeZone);
        if (triple == null) {
            throw new VisalloException("Unhandled combination of RDF triples");
        }
        if (ctx == null || ctx.isNewElement(triple)) {
            if (ctx != null) {
                elements.add(ctx.save(authorizations));
            }
            ctx = triple.createImportContext(ctx, this, authorizations);
        }
        ctx = triple.updateImportContext(ctx, this, authorizations);
        if (triple instanceof ConceptTypeVisalloRdfTriple) {
            this.setConceptType(ctx, sourceFileName, (ConceptTypeVisalloRdfTriple)triple, user);
            return ctx;
        }
        if (triple instanceof PropertyVisalloRdfTriple) {
            this.setProperty(ctx, sourceFileName, (PropertyVisalloRdfTriple)triple, user);
            return ctx;
        }
        if (triple instanceof AddEdgeVisalloRdfTriple) {
            return ctx;
        }
        throw new VisalloException("Unexpected triple type: " + triple.getClass().getName());
    }

    private void setProperty(ImportContext ctx, String sourceFileName, PropertyVisalloRdfTriple triple, User user) {
        ElementMutation m = ctx.getElementMutation();
        Date now = new Date();
        Metadata metadata = new Metadata();
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        if (sourceFileName != null) {
            VisalloProperties.SOURCE_FILE_NAME_METADATA.setMetadata(metadata, (Object)sourceFileName, defaultVisibility);
        }
        VisalloProperties.MODIFIED_DATE_METADATA.setMetadata(metadata, (Object)now, defaultVisibility);
        VisalloProperties.MODIFIED_BY_METADATA.setMetadata(metadata, (Object)user.getUserId(), defaultVisibility);
        VisalloProperties.CONFIDENCE_METADATA.setMetadata(metadata, (Object)0.5, defaultVisibility);
        if (!this.isLiteralVisibilityString(triple.getPropertyVisibilitySource())) {
            VisalloProperties.VISIBILITY_JSON_METADATA.setMetadata(metadata, (Object)new VisibilityJson(triple.getPropertyVisibilitySource()), defaultVisibility);
        }
        if (triple instanceof SetMetadataVisalloRdfTriple) {
            SetMetadataVisalloRdfTriple setMetadataVisalloRdfTriple = (SetMetadataVisalloRdfTriple)triple;
            ((ExistingElementMutation)m).setPropertyMetadata(triple.getPropertyKey(), triple.getPropertyName(), setMetadataVisalloRdfTriple.getMetadataName(), triple.getValue(), this.getVisibility(setMetadataVisalloRdfTriple.getMetadataVisibilitySource()));
        } else {
            m.addPropertyValue(triple.getPropertyKey(), triple.getPropertyName(), triple.getValue(), metadata, this.getVisibility(triple.getPropertyVisibilitySource()));
        }
    }

    private void setConceptType(ImportContext ctx, String sourceFileName, ConceptTypeVisalloRdfTriple triple, User user) {
        Date now = new Date();
        Visibility defaultVisibility = this.visibilityTranslator.getDefaultVisibility();
        Visibility elementVisibility = this.getVisibility(triple.getElementVisibilitySource());
        ElementMutation m = ctx.getElementMutation();
        VisalloProperties.CONCEPT_TYPE.setProperty(m, (Object)triple.getConceptType(), defaultVisibility);
        if (!this.isLiteralVisibilityString(triple.getElementVisibilitySource())) {
            VisibilityJson visibilityJson = new VisibilityJson(triple.getElementVisibilitySource());
            VisalloProperties.VISIBILITY_JSON.setProperty(m, (Object)visibilityJson, defaultVisibility);
        }
        VisalloProperties.MODIFIED_BY.setProperty(m, (Object)user.getUserId(), defaultVisibility);
        VisalloProperties.MODIFIED_DATE.setProperty(m, (Object)now, defaultVisibility);
        VisalloProperties.SOURCE.addPropertyValue(m, MULTIVALUE_KEY, (Object)sourceFileName, elementVisibility);
    }

    Visibility getVisibility(String visibilityString) {
        Visibility visibility = visibilityCache.get(visibilityString);
        if (visibility != null) {
            return visibility;
        }
        visibility = this.isLiteralVisibilityString(visibilityString) ? new VisalloVisibility(visibilityString.substring(1)).getVisibility() : this.visibilityTranslator.toVisibility(visibilityString).getVisibility();
        visibilityCache.put(visibilityString, visibility);
        return visibility;
    }

    private boolean isLiteralVisibilityString(String visibilitySource) {
        return visibilitySource != null && visibilitySource.startsWith("!");
    }

    Graph getGraph() {
        return this.graph;
    }
}

