/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import com.google.common.base.Strings;
import org.vertexium.ElementType;
import org.visallo.common.rdf.VisalloRdfTriple;

public abstract class ElementVisalloRdfTriple
extends VisalloRdfTriple {
    private final ElementType elementType;
    private final String elementId;
    private final String elementVisibilitySource;

    protected ElementVisalloRdfTriple(ElementType elementType, String elementId, String elementVisibilitySource) {
        this.elementType = elementType;
        this.elementId = elementId;
        this.elementVisibilitySource = elementVisibilitySource;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    public String getElementVisibilitySource() {
        return this.elementVisibilitySource;
    }

    protected String getElementRdfString() {
        String result = String.format("%s%s", this.getElementType() == ElementType.VERTEX ? "" : "EDGE:", this.getElementId());
        if (!Strings.isNullOrEmpty((String)this.getElementVisibilitySource())) {
            result = result + String.format("[%s]", this.getElementVisibilitySource());
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.getElementId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementVisalloRdfTriple that = (ElementVisalloRdfTriple)o;
        if (this.elementType != that.elementType) {
            return false;
        }
        if (this.elementId != null ? !this.elementId.equals(that.elementId) : that.elementId != null) {
            return false;
        }
        return !(this.elementVisibilitySource != null ? !this.elementVisibilitySource.equals(that.elementVisibilitySource) : that.elementVisibilitySource != null);
    }
}

