/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import java.io.File;
import org.visallo.core.exception.VisalloException;

class RdfFileLocator {
    RdfFileLocator() {
    }

    public static File findBestFile(File input) {
        File inputFile = RdfFileLocator.findRdfFile(input);
        if (inputFile == null && input.isDirectory()) {
            inputFile = RdfFileLocator.findFirstFile(input);
        }
        return inputFile;
    }

    public static File findRdfFile(File input) {
        return RdfFileLocator.findFile(input, new RdfFinder());
    }

    public static File findFirstFile(File input) {
        return RdfFileLocator.findFile(input, new FileFinder());
    }

    private static File findFile(File input, Finder finder) {
        if (input.isFile()) {
            return input;
        }
        File[] files = input.listFiles();
        if (files == null) {
            throw new VisalloException("Could not get files from: " + input.getAbsolutePath());
        }
        for (File file : files) {
            if (!finder.matches(file)) continue;
            return file;
        }
        for (File file : files) {
            File rdfFile;
            if (!file.isDirectory() || (rdfFile = RdfFileLocator.findFile(file, finder)) == null) continue;
            return rdfFile;
        }
        return null;
    }

    private static class RdfFinder
    extends Finder {
        private RdfFinder() {
        }

        @Override
        public boolean matches(File file) {
            if (!file.isFile()) {
                return false;
            }
            String fileName = file.getAbsolutePath().toLowerCase();
            return fileName.endsWith(".nt") || fileName.endsWith(".xml");
        }
    }

    private static class FileFinder
    extends Finder {
        private FileFinder() {
        }

        @Override
        public boolean matches(File file) {
            return file.isFile();
        }
    }

    private static abstract class Finder {
        private Finder() {
        }

        public abstract boolean matches(File var1);
    }
}

