/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import com.google.inject.Inject;
import com.hp.hpl.jena.shared.JenaException;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.visallo.common.rdf.RdfFileLocator;
import org.visallo.common.rdf.RdfTripleImportHelper;
import org.visallo.common.rdf.RdfXmlImportHelper;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class RdfImportHelper {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(RdfImportHelper.class);
    private final Graph graph;
    private final RdfXmlImportHelper rdfXmlImportHelper;
    private final RdfTripleImportHelper rdfTripleImportHelper;
    private boolean failOnFirstError = false;
    private boolean disableWorkQueues = false;

    public void setFailOnFirstError(boolean failOnFirstError) {
        this.failOnFirstError = failOnFirstError;
    }

    public void setDisableWorkQueues(boolean disableWorkQueues) {
        this.disableWorkQueues = disableWorkQueues;
    }

    @Inject
    public RdfImportHelper(Graph graph, RdfXmlImportHelper rdfXmlImportHelper, RdfTripleImportHelper rdfTripleImportHelper) {
        this.graph = graph;
        this.rdfXmlImportHelper = rdfXmlImportHelper;
        this.rdfTripleImportHelper = rdfTripleImportHelper;
    }

    public void importRdf(File input, TimeZone timeZone, Priority priority, String visibilitySource, User user, Authorizations authorizations) throws IOException {
        File inputFile = RdfFileLocator.findBestFile(input);
        LOGGER.info("Importing file: %s", new Object[]{inputFile.getAbsolutePath()});
        this.rdfTripleImportHelper.setFailOnFirstError(this.failOnFirstError);
        this.rdfTripleImportHelper.setDisableWorkQueues(this.disableWorkQueues);
        this.rdfXmlImportHelper.setDisableWorkQueues(this.disableWorkQueues);
        if (inputFile.getName().endsWith(".nt")) {
            this.importFileRdfTriple(inputFile, timeZone, priority, visibilitySource, user, authorizations);
        } else {
            try {
                this.importFileRdfXml(inputFile, priority, visibilitySource, user, authorizations);
            }
            catch (JenaException ex) {
                if (ex.getMessage().contains("Content is not allowed in prolog.")) {
                    this.importFileRdfTriple(inputFile, timeZone, priority, visibilitySource, user, authorizations);
                }
                throw ex;
            }
        }
        this.graph.flush();
    }

    private void importFileRdfTriple(File inputFile, TimeZone timeZone, Priority priority, String visibilitySource, User user, Authorizations authorizations) throws IOException {
        this.rdfTripleImportHelper.importRdfTriple(inputFile, timeZone, priority, visibilitySource, user, authorizations);
    }

    private void importFileRdfXml(File inputFile, Priority priority, String visibilitySource, User user, Authorizations authorizations) throws IOException {
        this.rdfXmlImportHelper.importRdfXml(inputFile, null, priority, visibilitySource, user, authorizations);
    }
}

