/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.type.GeoPoint;
import org.visallo.common.rdf.ElementVisalloRdfTriple;
import org.visallo.common.rdf.ImportContext;
import org.visallo.common.rdf.RdfTripleImportHelper;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.DirectoryEntity;

public abstract class PropertyVisalloRdfTriple
extends ElementVisalloRdfTriple {
    private final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(PropertyVisalloRdfTriple.class);
    private final String propertyKey;
    private final String propertyName;
    private final String propertyVisibilitySource;
    private final Object value;

    public PropertyVisalloRdfTriple(ElementType elementType, String elementId, String elementVisibilitySource, String propertyKey, String propertyName, String propertyVisibilitySource, Object value) {
        super(elementType, elementId, elementVisibilitySource);
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyVisibilitySource = propertyVisibilitySource;
        this.value = value;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyVisibilitySource() {
        return this.propertyVisibilitySource;
    }

    public Object getValue() {
        return this.value;
    }

    protected String getPropertyRdfString() {
        String result = this.getPropertyName();
        if (!Strings.isNullOrEmpty((String)this.getPropertyKey())) {
            result = result + String.format(":%s", this.escape(this.getPropertyKey(), ':'));
        }
        if (!Strings.isNullOrEmpty((String)this.getPropertyVisibilitySource())) {
            result = result + String.format("[%s]", this.getPropertyVisibilitySource());
        }
        return result;
    }

    protected String getValueRdfString() {
        if (this.getValue() == null) {
            throw new VisalloException("Unexpected null value");
        }
        if (this.getValue() instanceof String) {
            return String.format("\"%s\"", this.escape(this.getValue().toString(), '\"'));
        }
        if (this.getValue() instanceof Integer) {
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(this.getValue(), "http://www.w3.org/2001/XMLSchema#int");
        }
        if (this.getValue() instanceof Double || this.getValue() instanceof Float) {
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(this.getValue(), "http://www.w3.org/2001/XMLSchema#double");
        }
        if (this.getValue() instanceof Boolean) {
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(this.getValue(), "http://www.w3.org/2001/XMLSchema#boolean");
        }
        if (this.getValue() instanceof GeoPoint) {
            String geoPointStr = this.getValue().toString();
            geoPointStr = geoPointStr.substring(1, geoPointStr.length() - 1);
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(geoPointStr, "http://visallo.org#geolocation");
        }
        if (this.getValue() instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone(ZoneId.of("GMT")));
            cal.setTime((Date)this.getValue());
            String val = DatatypeConverter.printDateTime((Calendar)cal);
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(val, "http://www.w3.org/2001/XMLSchema#dateTime");
        }
        if (this.getValue() instanceof DirectoryEntity) {
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(((DirectoryEntity)this.getValue()).getId(), "http://visallo.org#directory/entity");
        }
        if (this.getValue() instanceof DateOnly) {
            return PropertyVisalloRdfTriple.getValueRdfStringWithType(this.getValue(), "http://www.w3.org/2001/XMLSchema#date");
        }
        this.LOGGER.warn("\"Unhandled value type " + this.getValue().getClass().getName() + " to convert to RDF string\"", new Object[0]);
        return null;
    }

    private static String getValueRdfStringWithType(Object value, String typeUri) {
        return String.format("\"%s\"^^<%s>", value, typeUri);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyVisalloRdfTriple that = (PropertyVisalloRdfTriple)o;
        if (this.propertyKey != null ? !this.propertyKey.equals(that.propertyKey) : that.propertyKey != null) {
            return false;
        }
        if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) {
            return false;
        }
        if (this.propertyVisibilitySource != null ? !this.propertyVisibilitySource.equals(that.propertyVisibilitySource) : that.propertyVisibilitySource != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public ImportContext createImportContext(ImportContext ctx, RdfTripleImportHelper rdfTripleImportHelper, Authorizations authorizations) {
        ElementMutation m = this.getMutationForUpdate(rdfTripleImportHelper, authorizations);
        return new ImportContext(this.getElementId(), m);
    }

    protected ElementMutation getMutationForUpdate(RdfTripleImportHelper rdfTripleImportHelper, Authorizations authorizations) {
        Graph graph = rdfTripleImportHelper.getGraph();
        if (this.getElementType() == ElementType.VERTEX) {
            return graph.prepareVertex(this.getElementId(), rdfTripleImportHelper.getVisibility(this.getElementVisibilitySource()));
        }
        Element element = this.getExistingElement(graph, this, authorizations);
        return element.prepareMutation();
    }

    protected Element getExistingElement(Graph graph, PropertyVisalloRdfTriple triple, Authorizations authorizations) {
        Vertex elem;
        Object object = elem = triple.getElementType() == ElementType.VERTEX ? graph.getVertex(triple.getElementId(), authorizations) : graph.getEdge(triple.getElementId(), authorizations);
        if (elem == null) {
            graph.flush();
            elem = triple.getElementType() == ElementType.VERTEX ? graph.getVertex(triple.getElementId(), authorizations) : graph.getEdge(triple.getElementId(), authorizations);
        }
        Preconditions.checkNotNull((Object)elem, (Object)("Could not find element with id " + triple.getElementId()));
        return elem;
    }
}

