/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import org.apache.commons.lang.StringEscapeUtils;

public class RdfTriple {
    private final Part first;
    private final Part second;
    private final Part third;
    private final Part forth;

    public RdfTriple(Part first, Part second, Part third, Part forth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.forth = forth;
    }

    public Part getFirst() {
        return this.first;
    }

    public Part getSecond() {
        return this.second;
    }

    public Part getThird() {
        return this.third;
    }

    public Part getForth() {
        return this.forth;
    }

    public static class LiteralPart
    extends Part {
        private final int stringStart;
        private final int stringEnd;
        private final Integer langStart;
        private final Integer langEnd;
        private final UriPart type;

        public LiteralPart(String line, int startIndex, int endIndex, int stringStart, int stringEnd, Integer langStart, Integer langEnd, UriPart type) {
            super(line, startIndex, endIndex);
            this.stringStart = stringStart;
            this.stringEnd = stringEnd;
            this.langStart = langStart;
            this.langEnd = langEnd;
            this.type = type;
        }

        public String getString() {
            String str = this.getLine().substring(this.stringStart, this.stringEnd);
            str = StringEscapeUtils.unescapeJava((String)str);
            return str;
        }

        public String getLanguage() {
            if (this.langStart == null || this.langEnd == null) {
                return "";
            }
            return this.getLine().substring(this.langStart, this.langEnd);
        }

        public UriPart getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return "StringPart{" + super.toString() + "}";
        }
    }

    public static class UriPart
    extends Part {
        public UriPart(String line, int startIndex, int endIndex) {
            super(line, startIndex, endIndex);
        }

        public String getUri() {
            return this.getLine().substring(this.getStartIndex() + 1, this.getEndIndex() - 1);
        }

        @Override
        public String toString() {
            return "UriPart{" + super.toString() + "}";
        }
    }

    public static class EmptyPart
    extends Part {
        public EmptyPart(String line, int startIndex, int endIndex) {
            super(line, startIndex, endIndex);
        }

        @Override
        public String toString() {
            return "EmptyPart{" + super.toString() + "}";
        }
    }

    public static class Part {
        private final String line;
        private final int startIndex;
        private final int endIndex;

        public Part(String line, int startIndex, int endIndex) {
            this.line = line;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        protected String getLine() {
            return this.line;
        }

        public String toString() {
            return this.line.substring(this.getStartIndex(), this.getEndIndex());
        }
    }
}

