/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import com.google.common.base.Strings;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.visallo.common.rdf.ImportContext;
import org.visallo.common.rdf.PropertyVisalloRdfTriple;
import org.visallo.common.rdf.RdfTripleImportHelper;

public class SetMetadataVisalloRdfTriple
extends PropertyVisalloRdfTriple {
    private final String metadataName;
    private final String metadataVisibilitySource;

    public SetMetadataVisalloRdfTriple(ElementType elementType, String elementId, String elementVisibilitySource, String propertyKey, String propertyName, String propertyVisibilitySource, String metadataName, String metadataVisibilitySource, Object value) {
        super(elementType, elementId, elementVisibilitySource, propertyKey, propertyName, propertyVisibilitySource, value);
        this.metadataName = metadataName;
        this.metadataVisibilitySource = metadataVisibilitySource;
    }

    public String getMetadataName() {
        return this.metadataName;
    }

    public String getMetadataVisibilitySource() {
        return this.metadataVisibilitySource;
    }

    public String toString() {
        String warning = "\"Unhandled value type " + this.getValue().getClass().getName() + " to convert to RDF string\"";
        String value = this.getValueRdfString();
        return String.format("%s<%s> <%s%s> %s", value == null ? "# " : "", this.getElementRdfString(), this.getPropertyRdfString(), this.getMetadataRdfString(), value == null ? warning : value);
    }

    protected String getMetadataRdfString() {
        String result = String.format("@%s", this.escape(this.getMetadataName(), '@'));
        if (!Strings.isNullOrEmpty((String)this.getMetadataVisibilitySource())) {
            result = result + String.format("[%s]", this.getMetadataVisibilitySource());
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetMetadataVisalloRdfTriple that = (SetMetadataVisalloRdfTriple)o;
        if (!this.metadataName.equals(that.metadataName)) {
            return false;
        }
        if (!this.metadataVisibilitySource.equals(that.metadataVisibilitySource)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public ImportContext updateImportContext(ImportContext ctx, RdfTripleImportHelper rdfTripleImportHelper, Authorizations authorizations) {
        if (!(ctx.getElementMutation() instanceof ExistingElementMutation)) {
            ctx.save(authorizations);
            Element element = this.getExistingElement(rdfTripleImportHelper.getGraph(), this, authorizations);
            ExistingElementMutation m = element.prepareMutation();
            return new ImportContext(this.getElementId(), (ElementMutation)m);
        }
        return super.updateImportContext(ctx, rdfTripleImportHelper, authorizations);
    }
}

