/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import org.junit.Assert;
import org.junit.Test;
import org.visallo.common.rdf.RdfTriple;
import org.visallo.common.rdf.RdfTripleParser;

public class RdfTripleParserTest {
    @Test
    public void testParseLinePropertyValue() throws Exception {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://dbpedia.org/resource/Aristotle> <http://xmlns.com/foaf/0.1/name> \"Aristotle\"@en .");
        Assert.assertTrue((boolean)(result.getFirst() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://dbpedia.org/resource/Aristotle", (Object)((RdfTriple.UriPart)result.getFirst()).getUri());
        Assert.assertTrue((boolean)(result.getSecond() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://xmlns.com/foaf/0.1/name", (Object)((RdfTriple.UriPart)result.getSecond()).getUri());
        Assert.assertTrue((boolean)(result.getThird() instanceof RdfTriple.LiteralPart));
        Assert.assertEquals((Object)"Aristotle", (Object)((RdfTriple.LiteralPart)result.getThird()).getString());
        Assert.assertEquals((Object)"en", (Object)((RdfTriple.LiteralPart)result.getThird()).getLanguage());
        Assert.assertEquals(null, (Object)((RdfTriple.LiteralPart)result.getThird()).getType());
        Assert.assertTrue((boolean)(result.getForth() instanceof RdfTriple.EmptyPart));
    }

    @Test
    public void testParseLinePropertyValueWithoutLanguage() throws Exception {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://dbpedia.org/resource/Aristotle> <http://xmlns.com/foaf/0.1/name> \"Aristotle\" .");
        Assert.assertEquals((Object)"", (Object)((RdfTriple.LiteralPart)result.getThird()).getLanguage());
    }

    @Test
    public void testParseLinePropertyValueWithEscapes() throws Exception {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://visallo.org/jsonObject> <http://visallo.org/jsonProperty> \"{\\\"property1\\\": \\\"value1\\\\with slash\\\"}\" .");
        Assert.assertEquals((Object)"{\"property1\": \"value1\\with slash\"}", (Object)((RdfTriple.LiteralPart)result.getThird()).getString());
    }

    @Test
    public void testParseLinePropertyValueWithSpecialCharacters() throws Exception {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://visallo.org/jsonObject> <http://visallo.org/jsonProperty> \"<>/\" .");
        Assert.assertEquals((Object)"<>/", (Object)((RdfTriple.LiteralPart)result.getThird()).getString());
    }

    @Test
    public void testParseLinePropertyValueWithoutLanguageAndFourth() throws Exception {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://dbpedia.org/resource/Aristotle> <http://xmlns.com/foaf/0.1/name> \"Aristotle\"");
        Assert.assertEquals((Object)"", (Object)((RdfTriple.LiteralPart)result.getThird()).getLanguage());
    }

    @Test
    public void testParseLineDateProperty() {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://dbpedia.org/resource/Abraham_Lincoln> <http://dbpedia.org/ontology/birthDate> \"1809-02-12\"^^<http://www.w3.org/2001/XMLSchema#date> .");
        Assert.assertTrue((boolean)(result.getFirst() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://dbpedia.org/resource/Abraham_Lincoln", (Object)((RdfTriple.UriPart)result.getFirst()).getUri());
        Assert.assertTrue((boolean)(result.getSecond() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://dbpedia.org/ontology/birthDate", (Object)((RdfTriple.UriPart)result.getSecond()).getUri());
        Assert.assertTrue((boolean)(result.getThird() instanceof RdfTriple.LiteralPart));
        Assert.assertEquals((Object)"1809-02-12", (Object)((RdfTriple.LiteralPart)result.getThird()).getString());
        Assert.assertEquals((Object)"", (Object)((RdfTriple.LiteralPart)result.getThird()).getLanguage());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema#date", (Object)((RdfTriple.LiteralPart)result.getThird()).getType().getUri());
        Assert.assertTrue((boolean)(result.getForth() instanceof RdfTriple.EmptyPart));
    }

    @Test
    public void testParseLineEdge() {
        RdfTriple result = RdfTripleParser.parseLine((String)"<http://dbpedia.org/resource/Abraham_Lincoln> <http://dbpedia.org/ontology/birthPlace> <http://dbpedia.org/resource/Hardin_County,_Kentucky> .");
        Assert.assertTrue((boolean)(result.getFirst() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://dbpedia.org/resource/Abraham_Lincoln", (Object)((RdfTriple.UriPart)result.getFirst()).getUri());
        Assert.assertTrue((boolean)(result.getSecond() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://dbpedia.org/ontology/birthPlace", (Object)((RdfTriple.UriPart)result.getSecond()).getUri());
        Assert.assertTrue((boolean)(result.getThird() instanceof RdfTriple.UriPart));
        Assert.assertEquals((Object)"http://dbpedia.org/resource/Hardin_County,_Kentucky", (Object)((RdfTriple.UriPart)result.getThird()).getUri());
        Assert.assertTrue((boolean)(result.getForth() instanceof RdfTriple.EmptyPart));
    }
}

