/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.util.IterableUtils;
import org.visallo.common.rdf.RdfXmlImportHelper;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.DirectVisibilityTranslator;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.VisibilityJson;

@RunWith(value=MockitoJUnitRunner.class)
public class RdfXmlImportHelperTest {
    private RdfXmlImportHelper rdfXmlImportHelper;
    private InMemoryGraph graph;
    private String defaultVisibilitySource;
    private String sourceFileName;
    private Authorizations authorizations;
    @Mock
    private WorkQueueRepository workQueueRepository;
    @Mock
    private User user;
    @Mock
    private OntologyRepository ontologyRepository;
    @Mock
    private WorkspaceRepository workspaceRepository;

    @Before
    public void setUp() {
        this.graph = InMemoryGraph.create();
        this.authorizations = this.graph.createAuthorizations(new String[]{"A"});
        DirectVisibilityTranslator visibilityTranslator = new DirectVisibilityTranslator();
        Mockito.when((Object)this.user.getUserId()).thenReturn((Object)"user1");
        this.rdfXmlImportHelper = new RdfXmlImportHelper((Graph)this.graph, this.workQueueRepository, this.ontologyRepository, this.workspaceRepository, (VisibilityTranslator)visibilityTranslator);
        this.defaultVisibilitySource = "";
        this.sourceFileName = "test.rdf";
        this.graph.flush();
    }

    @Test
    public void testImportVertexHasMetadata() throws IOException {
        File file = new File(RdfXmlImportHelperTest.class.getResource(this.sourceFileName).getFile());
        this.rdfXmlImportHelper.importRdfXml(file, null, Priority.HIGH, this.defaultVisibilitySource, this.user, this.authorizations);
        Vertex v5 = this.graph.getVertex("COMPANY_v5analytics", this.authorizations);
        Assert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)v5.getProperties()));
        Assert.assertEquals((Object)"http://visallo.org/test#company", (Object)VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)v5, null));
        Assert.assertEquals((Object)"user1", (Object)VisalloProperties.MODIFIED_BY.getPropertyValue((Element)v5, null));
        Assert.assertNotNull((Object)VisalloProperties.MODIFIED_DATE.getPropertyValue((Element)v5));
        VisibilityJson visibilityJson = new VisibilityJson(this.defaultVisibilitySource);
        Assert.assertEquals((Object)visibilityJson, (Object)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)v5, null));
        Property property = VisalloProperties.TITLE.getProperty((Element)v5, "RdfXmlImportHelper");
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)"V5 Analytics", (Object)property.getValue());
        Metadata metadata = property.getMetadata();
        Assert.assertEquals((long)3L, (long)metadata.entrySet().size());
        Assert.assertTrue((boolean)metadata.containsKey(VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataKey()));
        Assert.assertTrue((boolean)metadata.containsKey(VisalloProperties.MODIFIED_BY_METADATA.getMetadataKey()));
        Assert.assertTrue((boolean)metadata.containsKey(VisalloProperties.MODIFIED_DATE_METADATA.getMetadataKey()));
        Edge e1 = this.graph.getEdge("PERSON_susan_http://visallo.org#worksFor_COMPANY_v5analytics", this.authorizations);
        Assert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)e1.getProperties()));
        Assert.assertEquals((Object)"user1", (Object)VisalloProperties.MODIFIED_BY.getPropertyValue((Element)e1, null));
        Assert.assertNotNull((Object)VisalloProperties.MODIFIED_DATE.getPropertyValue((Element)e1));
        Assert.assertEquals((Object)visibilityJson, (Object)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)e1, null));
    }
}

