/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import com.google.common.base.Strings;
import org.vertexium.Authorizations;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.mutation.ElementMutation;
import org.visallo.common.rdf.ImportContext;
import org.visallo.common.rdf.RdfTripleImportHelper;
import org.visallo.common.rdf.VisalloRdfTriple;

public class AddEdgeVisalloRdfTriple
extends VisalloRdfTriple {
    private final String edgeId;
    private final String edgeLabel;
    private final String outVertexId;
    private final String inVertexId;
    private final String edgeVisibilitySource;

    protected AddEdgeVisalloRdfTriple(String edgeId, String outVertexId, String inVertexId, String edgeLabel, String edgeVisibilitySource) {
        this.edgeId = edgeId;
        this.edgeLabel = edgeLabel;
        this.outVertexId = outVertexId;
        this.inVertexId = inVertexId;
        this.edgeVisibilitySource = edgeVisibilitySource;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    @Override
    public String getElementId() {
        return this.getEdgeId();
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public String getOutVertexId() {
        return this.outVertexId;
    }

    public String getInVertexId() {
        return this.inVertexId;
    }

    public String getEdgeVisibilitySource() {
        return this.edgeVisibilitySource;
    }

    public String toString() {
        String label = this.getEdgeLabel();
        if (!Strings.isNullOrEmpty((String)this.getEdgeId())) {
            label = label + ":" + this.escape(this.getEdgeId(), ':');
        }
        if (!Strings.isNullOrEmpty((String)this.getEdgeVisibilitySource())) {
            label = label + String.format("[%s]", this.getEdgeVisibilitySource());
        }
        return String.format("<%s> <%s> <%s>", this.getOutVertexId(), label, this.getInVertexId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddEdgeVisalloRdfTriple that = (AddEdgeVisalloRdfTriple)o;
        if (this.edgeId != null ? !this.edgeId.equals(that.edgeId) : that.edgeId != null) {
            return false;
        }
        if (this.edgeLabel != null ? !this.edgeLabel.equals(that.edgeLabel) : that.edgeLabel != null) {
            return false;
        }
        if (this.outVertexId != null ? !this.outVertexId.equals(that.outVertexId) : that.outVertexId != null) {
            return false;
        }
        if (this.inVertexId != null ? !this.inVertexId.equals(that.inVertexId) : that.inVertexId != null) {
            return false;
        }
        if (this.edgeVisibilitySource != null ? !this.edgeVisibilitySource.equals(that.edgeVisibilitySource) : that.edgeVisibilitySource != null) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public ImportContext createImportContext(ImportContext ctx, RdfTripleImportHelper rdfTripleImportHelper, Authorizations authorizations) {
        EdgeBuilderByVertexId m = rdfTripleImportHelper.getGraph().prepareEdge(this.getEdgeId(), this.getOutVertexId(), this.getInVertexId(), this.getEdgeLabel(), rdfTripleImportHelper.getVisibility(this.getEdgeVisibilitySource()));
        return new ImportContext(this.getEdgeId(), (ElementMutation)m);
    }

    @Override
    public int hashCode() {
        return this.edgeId.hashCode();
    }
}

