/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import org.vertexium.Authorizations;
import org.vertexium.ElementType;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.mutation.ElementMutation;
import org.visallo.common.rdf.ElementVisalloRdfTriple;
import org.visallo.common.rdf.ImportContext;
import org.visallo.common.rdf.RdfTripleImportHelper;

public class ConceptTypeVisalloRdfTriple
extends ElementVisalloRdfTriple {
    private final String conceptType;

    public ConceptTypeVisalloRdfTriple(String vertexId, String vertexVisibilitySource, String conceptType) {
        super(ElementType.VERTEX, vertexId, vertexVisibilitySource);
        this.conceptType = conceptType;
    }

    public String getConceptType() {
        return this.conceptType;
    }

    public String toString() {
        return String.format("<%s> <%s> <%s>", this.getElementRdfString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", this.getConceptType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConceptTypeVisalloRdfTriple that = (ConceptTypeVisalloRdfTriple)o;
        if (!this.conceptType.equals(that.conceptType)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public ImportContext createImportContext(ImportContext ctx, RdfTripleImportHelper rdfTripleImportHelper, Authorizations authorizations) {
        Visibility elementVisibility = rdfTripleImportHelper.getVisibility(this.getElementVisibilitySource());
        VertexBuilder m = rdfTripleImportHelper.getGraph().prepareVertex(this.getElementId(), elementVisibility);
        return new ImportContext(this.getElementId(), (ElementMutation)m);
    }
}

