/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.common.rdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.common.rdf.AddEdgeVisalloRdfTriple;
import org.visallo.common.rdf.ConceptTypeVisalloRdfTriple;
import org.visallo.common.rdf.SetMetadataVisalloRdfTriple;
import org.visallo.common.rdf.SetPropertyVisalloRdfTriple;
import org.visallo.common.rdf.VisalloRdfTriple;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.web.clientapi.model.VisibilityJson;

public class RdfExportHelper {
    public String exportElementToRdfTriple(Element element) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.exportElementToRdfTriple(element, (OutputStream)out);
        }
        catch (IOException ex) {
            throw new VisalloException("Could not export element", (Throwable)ex);
        }
        return out.toString();
    }

    public void exportElementsToRdfTriple(Iterable<? extends Element> elements, OutputStream out) throws IOException {
        boolean first = true;
        for (Element element : elements) {
            if (!first) {
                out.write("\n".getBytes());
            }
            this.exportElementToRdfTriple(element, out);
            first = false;
        }
    }

    public void exportElementToRdfTriple(Element element, OutputStream out) throws IOException {
        this.writeElementRdfTripleComment(element, out);
        this.writeElementRdfTriple(element, out);
        for (Property property : element.getProperties()) {
            this.writePropertyRdfTriples(element, property, out);
        }
    }

    private void writeElementRdfTripleComment(Element element, OutputStream out) throws IOException {
        out.write(String.format("# %s: %s", element instanceof Vertex ? "Vertex" : "Edge", element.getId()).getBytes());
        out.write("\n".getBytes());
    }

    private void writeElementRdfTriple(Element element, OutputStream out) throws IOException {
        String elementVisibilitySource = this.getVisibilitySource(element);
        if (element instanceof Vertex) {
            String conceptType = VisalloProperties.CONCEPT_TYPE.getPropertyValue(element, "http://www.w3.org/2002/07/owl#Thing");
            this.write(new ConceptTypeVisalloRdfTriple(element.getId(), elementVisibilitySource, conceptType), out);
        } else if (element instanceof Edge) {
            Edge edge = (Edge)element;
            this.write(new AddEdgeVisalloRdfTriple(element.getId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel(), elementVisibilitySource), out);
        } else {
            throw new VisalloException("Unhandled element type: " + element.getClass().getName());
        }
    }

    private void writePropertyRdfTriples(Element element, Property property, OutputStream out) throws IOException {
        SetPropertyVisalloRdfTriple setPropertyVisalloRdfTriple = new SetPropertyVisalloRdfTriple(element instanceof Vertex ? ElementType.VERTEX : ElementType.EDGE, element.getId(), this.getVisibilitySource(element), property.getKey(), property.getName(), this.getVisibilitySource(property), property.getValue());
        this.write(setPropertyVisalloRdfTriple, out);
        if (setPropertyVisalloRdfTriple.getValueRdfString() != null) {
            for (Metadata.Entry entry : property.getMetadata().entrySet()) {
                this.writeMetadataEntryRdfTriple(element, property, entry, out);
            }
        }
    }

    private void writeMetadataEntryRdfTriple(Element element, Property property, Metadata.Entry entry, OutputStream out) throws IOException {
        this.write(new SetMetadataVisalloRdfTriple(element instanceof Vertex ? ElementType.VERTEX : ElementType.EDGE, element.getId(), this.getVisibilitySource(element), property.getKey(), property.getName(), this.getVisibilitySource(property), entry.getKey(), entry.getVisibility().toString(), entry.getValue()), out);
    }

    private void write(VisalloRdfTriple triple, OutputStream out) throws IOException {
        out.write(triple.toString().getBytes());
        out.write("\n".getBytes());
    }

    private String getVisibilitySource(Element element) {
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue(element);
        if (visibilityJson != null) {
            return visibilityJson.getSource();
        }
        return null;
    }

    private String getVisibilitySource(Property property) {
        VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON_METADATA.getMetadataValue(property.getMetadata());
        if (visibilityJson != null) {
            return visibilityJson.getSource();
        }
        return null;
    }
}

