/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.beust.jcommander.Parameter;
import java.lang.management.ManagementFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.visallo.core.cmdline.CommandLineTool;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.WebServer;

public class JettyWebServer
extends WebServer {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(JettyWebServer.class, (String)"web");
    private static final int MAX_FORM_CONTENT_SIZE = 10000000;
    private Server server;
    @Parameter(names={"--dontjoin"}, description="Don't join the server thread and continue with exit")
    private boolean dontJoin = false;

    public static void main(String[] args) throws Exception {
        CommandLineTool.main((CommandLineTool)new JettyWebServer(), (String[])args, (boolean)false);
    }

    protected int run() throws Exception {
        this.server = new Server();
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        this.server.addBean((Object)Log.getLog());
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(this.getHttpsPort());
        ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        httpConnector.setPort(this.getHttpPort());
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this.getKeyStorePath().getAbsolutePath());
        sslContextFactory.setKeyStorePassword(super.getKeyStorePassword());
        sslContextFactory.setTrustStorePath(this.getTrustStorePath().getAbsolutePath());
        sslContextFactory.setTrustStorePassword(super.getTrustStorePassword());
        sslContextFactory.setNeedClientAuth(super.getRequireClientCert());
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector httpsConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        httpsConnector.setPort(this.getHttpsPort());
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        webAppContext.setContextPath(this.getContextPath());
        webAppContext.setWar(this.getWebAppDir().getAbsolutePath());
        webAppContext.setSessionHandler(new HashSessionManager().getSessionHandler());
        webAppContext.setMaxFormContentSize(10000000);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{webAppContext});
        this.server.setConnectors(new Connector[]{httpConnector, httpsConnector});
        this.server.setHandler((Handler)contexts);
        this.server.start();
        webAppContext.getSessionHandler().getSessionManager().setMaxInactiveInterval(this.getSessionTimeout() * 60);
        this.afterServerStart();
        LOGGER.info("Session timeout is %d seconds", new Object[]{webAppContext.getSessionHandler().getSessionManager().getMaxInactiveInterval()});
        if (!this.dontJoin) {
            this.server.join();
        }
        return 0;
    }

    protected Server getServer() {
        return this.server;
    }

    protected void afterServerStart() {
        String message = String.format("Listening on http port %d and https port %d", this.getHttpPort(), this.getHttpsPort());
        LOGGER.info(message, new Object[0]);
        System.out.println(message);
    }
}

