/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.ontology;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.vertexium.Authorizations;
import org.visallo.core.model.ontology.OntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.web.clientapi.model.PropertyType;

public class InMemoryOntologyProperty
extends OntologyProperty {
    private String title;
    private boolean userVisible;
    private boolean searchable;
    private boolean sortable;
    private boolean addable;
    private String displayName;
    private String propertyGroup;
    private PropertyType dataType;
    private Map<String, String> possibleValues;
    private String displayType;
    private Double boost;
    private String validationFormula;
    private String displayFormula;
    private boolean updateable;
    private boolean deleteable;
    private ImmutableList<String> dependentPropertyIris = ImmutableList.of();
    private List<String> intents = new ArrayList<String>();
    private List<String> textIndexHints = new ArrayList<String>();

    public String getTitle() {
        return this.title;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getUserVisible() {
        return this.userVisible;
    }

    public PropertyType getDataType() {
        return this.dataType;
    }

    public Double getBoost() {
        return this.boost;
    }

    public Map<String, String> getPossibleValues() {
        return this.possibleValues;
    }

    public String getPropertyGroup() {
        return this.propertyGroup;
    }

    public boolean getSearchable() {
        return this.searchable;
    }

    public boolean getAddable() {
        return this.addable;
    }

    public boolean getSortable() {
        return this.sortable;
    }

    public String getValidationFormula() {
        return this.validationFormula;
    }

    public String getDisplayFormula() {
        return this.displayFormula;
    }

    public ImmutableList<String> getDependentPropertyIris() {
        return this.dependentPropertyIris;
    }

    public boolean getDeleteable() {
        return this.deleteable;
    }

    public boolean getUpdateable() {
        return this.updateable;
    }

    public String[] getIntents() {
        return this.intents.toArray(new String[this.intents.size()]);
    }

    public String[] getTextIndexHints() {
        return this.textIndexHints.toArray(new String[this.textIndexHints.size()]);
    }

    public void addTextIndexHints(String textIndexHints, Authorizations authorizations) {
        this.addTextIndexHints(textIndexHints);
    }

    public void addTextIndexHints(String textIndexHints) {
        this.textIndexHints.add(textIndexHints);
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public void setAddable(boolean addable) {
        this.addable = addable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUserVisible(boolean userVisible) {
        this.userVisible = userVisible;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDataType(PropertyType dataType) {
        this.dataType = dataType;
    }

    public void setPossibleValues(Map<String, String> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public void setBoost(Double boost) {
        this.boost = boost;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public void setPropertyGroup(String propertyGroup) {
        this.propertyGroup = propertyGroup;
    }

    public void setValidationFormula(String validationFormula) {
        this.validationFormula = validationFormula;
    }

    public void setDisplayFormula(String displayFormula) {
        this.displayFormula = displayFormula;
    }

    public void setDependentPropertyIris(Collection<String> dependentPropertyIris) {
        this.dependentPropertyIris = dependentPropertyIris == null ? ImmutableList.of() : ImmutableList.copyOf(dependentPropertyIris);
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public void setDeleteable(boolean deleteable) {
        this.deleteable = deleteable;
    }

    public void setProperty(String name, Object value, Authorizations authorizations) {
        if (OntologyProperties.DISPLAY_TYPE.getPropertyName().equals(name)) {
            this.displayType = (String)value;
        } else if (OntologyProperties.DISPLAY_FORMULA.getPropertyName().equals(name)) {
            this.displayFormula = (String)value;
        } else if (OntologyProperties.DISPLAY_NAME.getPropertyName().equals(name)) {
            this.displayName = (String)value;
        } else if (OntologyProperties.PROPERTY_GROUP.getPropertyName().equals(name)) {
            this.propertyGroup = (String)value;
        } else if (OntologyProperties.SEARCHABLE.getPropertyName().equals(name)) {
            this.searchable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else if (OntologyProperties.SORTABLE.getPropertyName().equals(name)) {
            this.sortable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else if (OntologyProperties.ADDABLE.getPropertyName().equals(name)) {
            this.addable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else if (OntologyProperties.USER_VISIBLE.getPropertyName().equals(name)) {
            this.userVisible = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else if (OntologyProperties.DELETEABLE.getPropertyName().equals(name)) {
            this.deleteable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        } else if (OntologyProperties.UPDATEABLE.getPropertyName().equals(name)) {
            this.updateable = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        }
    }

    public void addIntent(String intent) {
        this.intents.add(intent);
    }

    public void addIntent(String intent, Authorizations authorizations) {
        this.intents.add(intent);
    }

    public void removeIntent(String intent, Authorizations authorizations) {
        this.intents.remove(intent);
    }
}

