/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.ontology;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.ReaderDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.TextIndexHint;
import org.vertexium.inmemory.InMemoryAuthorizations;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IterableUtils;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyProperties;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepositoryBase;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.vertexium.model.ontology.InMemoryConcept;
import org.visallo.vertexium.model.ontology.InMemoryOntologyProperty;
import org.visallo.vertexium.model.ontology.InMemoryRelationship;
import org.visallo.web.clientapi.model.PropertyType;

public class InMemoryOntologyRepository
extends OntologyRepositoryBase {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(InMemoryOntologyRepository.class);
    private final Graph graph;
    private final OWLOntologyLoaderConfiguration owlConfig = new OWLOntologyLoaderConfiguration();
    private final Map<String, InMemoryConcept> conceptsCache = new HashMap<String, InMemoryConcept>();
    private final Map<String, InMemoryOntologyProperty> propertiesCache = new HashMap<String, InMemoryOntologyProperty>();
    private final Map<String, InMemoryRelationship> relationshipsCache = new HashMap<String, InMemoryRelationship>();
    private final List<OwlData> fileCache = new ArrayList<OwlData>();
    private Authorizations authorizations;

    @Inject
    public InMemoryOntologyRepository(Graph graph, Configuration configuration, LockRepository lockRepository) throws Exception {
        super(configuration, lockRepository);
        this.graph = graph;
        this.clearCache();
        this.authorizations = new InMemoryAuthorizations(new String[]{"ontology"});
        this.owlConfig.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.loadOntologies(this.getConfiguration(), this.authorizations);
    }

    protected Concept importOntologyClass(OWLOntology o, OWLClass ontologyClass, File inDir, Authorizations authorizations) throws IOException {
        InMemoryConcept concept = (InMemoryConcept)super.importOntologyClass(o, ontologyClass, inDir, authorizations);
        this.conceptsCache.put(concept.getIRI(), concept);
        return concept;
    }

    protected Relationship importObjectProperty(OWLOntology o, OWLObjectProperty objectProperty, Authorizations authorizations) {
        InMemoryRelationship relationship = (InMemoryRelationship)super.importObjectProperty(o, objectProperty, authorizations);
        this.relationshipsCache.put(relationship.getIRI(), relationship);
        return relationship;
    }

    protected void setIconProperty(Concept concept, File inDir, String glyphIconFileName, String propertyKey, Authorizations authorizations) throws IOException {
        if (glyphIconFileName == null) {
            concept.setProperty(propertyKey, null, authorizations);
        } else {
            File iconFile = new File(inDir, glyphIconFileName);
            if (!iconFile.exists()) {
                throw new RuntimeException("Could not find icon file: " + iconFile.toString());
            }
            try (FileInputStream iconFileIn = new FileInputStream(iconFile);){
                concept.setProperty(propertyKey, (Object)IOUtils.toByteArray((InputStream)iconFileIn), authorizations);
            }
            catch (IOException ex) {
                throw new VisalloException("Failed to set glyph icon to " + iconFile, (Throwable)ex);
            }
        }
    }

    protected void addEntityGlyphIconToEntityConcept(Concept entityConcept, byte[] rawImg) {
        entityConcept.setProperty(OntologyProperties.GLYPH_ICON.getPropertyName(), (Object)rawImg, null);
    }

    protected void storeOntologyFile(InputStream inputStream, IRI documentIRI) {
        try {
            byte[] inFileData = IOUtils.toByteArray((InputStream)inputStream);
            this.fileCache.add(new OwlData(documentIRI.toString(), inFileData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isOntologyDefined(String iri) {
        for (OwlData owlData : this.fileCache) {
            if (!owlData.iri.equals(iri)) continue;
            return true;
        }
        return false;
    }

    public void updatePropertyDependentIris(OntologyProperty property, Collection<String> dependentPropertyIris) {
        InMemoryOntologyProperty inMemoryOntologyProperty = (InMemoryOntologyProperty)property;
        inMemoryOntologyProperty.setDependentPropertyIris(dependentPropertyIris);
    }

    protected List<OWLOntology> loadOntologyFiles(OWLOntologyManager m, OWLOntologyLoaderConfiguration config, IRI excludedIRI) throws Exception {
        ArrayList<OWLOntology> loadedOntologies = new ArrayList<OWLOntology>();
        for (OwlData owlData : this.fileCache) {
            IRI visalloBaseOntologyIRI = IRI.create((String)owlData.iri);
            if (excludedIRI != null && excludedIRI.equals((Object)visalloBaseOntologyIRI)) continue;
            ByteArrayInputStream visalloBaseOntologyIn = new ByteArrayInputStream(owlData.data);
            Throwable throwable = null;
            try {
                InputStreamReader visalloBaseOntologyReader = new InputStreamReader(visalloBaseOntologyIn);
                LOGGER.info("Loading existing ontology: %s", new Object[]{owlData.iri});
                ReaderDocumentSource visalloBaseOntologySource = new ReaderDocumentSource((Reader)visalloBaseOntologyReader, visalloBaseOntologyIRI);
                OWLOntology o = m.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)visalloBaseOntologySource, config);
                loadedOntologies.add(o);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (visalloBaseOntologyIn == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)visalloBaseOntologyIn).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)visalloBaseOntologyIn).close();
            }
        }
        return loadedOntologies;
    }

    protected OntologyProperty addPropertyTo(List<Concept> concepts, List<Relationship> relationships, String propertyIri, String displayName, PropertyType dataType, Map<String, String> possibleValues, Collection<TextIndexHint> textIndexHints, boolean userVisible, boolean searchable, boolean addable, boolean sortable, String displayType, String propertyGroup, Double boost, String validationFormula, String displayFormula, ImmutableList<String> dependentPropertyIris, String[] intents, boolean deleteable, boolean updateable) {
        Preconditions.checkNotNull(concepts, (Object)"concept was null");
        InMemoryOntologyProperty property = this.getOrCreatePropertyType(propertyIri, dataType, displayName, possibleValues, textIndexHints, userVisible, searchable, addable, sortable, displayType, propertyGroup, boost, validationFormula, displayFormula, dependentPropertyIris, intents, deleteable, updateable);
        for (Concept concept : concepts) {
            concept.getProperties().add(property);
        }
        for (Relationship relationship : relationships) {
            relationship.getProperties().add(property);
        }
        Preconditions.checkNotNull((Object)((Object)property), (Object)("Could not find property: " + propertyIri));
        return property;
    }

    public void updatePropertyDomainIris(OntologyProperty property, Set<String> domainIris) {
        for (Concept concept : this.getConceptsWithProperties()) {
            if (!concept.getProperties().contains(property) || domainIris.remove(concept.getIRI())) continue;
            concept.getProperties().remove(property);
        }
        for (String domainIri : domainIris) {
            this.getConceptByIRI(domainIri).getProperties().add(property);
        }
    }

    protected void getOrCreateInverseOfRelationship(Relationship fromRelationship, Relationship inverseOfRelationship) {
        InMemoryRelationship fromRelationshipMem = (InMemoryRelationship)fromRelationship;
        InMemoryRelationship inverseOfRelationshipMem = (InMemoryRelationship)inverseOfRelationship;
        fromRelationshipMem.addInverseOf(inverseOfRelationshipMem);
        inverseOfRelationshipMem.addInverseOf(fromRelationshipMem);
    }

    private InMemoryOntologyProperty getOrCreatePropertyType(String propertyIri, PropertyType dataType, String displayName, Map<String, String> possibleValues, Collection<TextIndexHint> textIndexHints, boolean userVisible, boolean searchable, boolean addable, boolean sortable, String displayType, String propertyGroup, Double boost, String validationFormula, String displayFormula, ImmutableList<String> dependentPropertyIris, String[] intents, boolean deleteable, boolean updateabale) {
        InMemoryOntologyProperty property = (InMemoryOntologyProperty)this.getPropertyByIRI(propertyIri);
        if (property == null) {
            searchable = this.determineSearchable(propertyIri, dataType, textIndexHints, searchable);
            this.definePropertyOnGraph(this.graph, propertyIri, dataType, textIndexHints, boost, sortable);
            property = new InMemoryOntologyProperty();
            property.setDataType(dataType);
            property.setUserVisible(userVisible);
            property.setSearchable(searchable);
            property.setAddable(addable);
            property.setSortable(sortable);
            property.setTitle(propertyIri);
            property.setBoost(boost);
            property.setDisplayType(displayType);
            property.setPropertyGroup(propertyGroup);
            property.setValidationFormula(validationFormula);
            property.setDisplayFormula(displayFormula);
            property.setDependentPropertyIris((Collection<String>)dependentPropertyIris);
            property.setDeleteable(deleteable);
            property.setUpdateable(updateabale);
            if (intents != null) {
                for (String intent : intents) {
                    property.addIntent(intent);
                }
            }
            if (displayName != null && !displayName.trim().isEmpty()) {
                property.setDisplayName(displayName);
            }
            if (textIndexHints != null && textIndexHints.size() > 0) {
                for (TextIndexHint textIndexHint : textIndexHints) {
                    property.addTextIndexHints(textIndexHint.toString());
                }
            }
            property.setPossibleValues(possibleValues);
            this.propertiesCache.put(propertyIri, property);
        }
        return property;
    }

    public void clearCache() {
    }

    public Iterable<Relationship> getRelationships() {
        return new ConvertingIterable<InMemoryRelationship, Relationship>(this.relationshipsCache.values()){

            protected Relationship convert(InMemoryRelationship InMemRelationship) {
                return InMemRelationship;
            }
        };
    }

    public Iterable<OntologyProperty> getProperties() {
        return new ConvertingIterable<InMemoryOntologyProperty, OntologyProperty>(this.propertiesCache.values()){

            protected OntologyProperty convert(InMemoryOntologyProperty ontologyProperty) {
                return ontologyProperty;
            }
        };
    }

    public String getDisplayNameForLabel(String relationshipIRI) {
        InMemoryRelationship relationship = this.relationshipsCache.get(relationshipIRI);
        Preconditions.checkNotNull((Object)((Object)relationship), (Object)("Could not find relationship " + relationshipIRI));
        return relationship.getDisplayName();
    }

    public OntologyProperty getPropertyByIRI(String propertyIRI) {
        return this.propertiesCache.get(propertyIRI);
    }

    public Relationship getRelationshipByIRI(String relationshipIRI) {
        return this.relationshipsCache.get(relationshipIRI);
    }

    public boolean hasRelationshipByIRI(String relationshipIRI) {
        return this.getRelationshipByIRI(relationshipIRI) != null;
    }

    public Iterable<Concept> getConceptsWithProperties() {
        return new ConvertingIterable<InMemoryConcept, Concept>(this.conceptsCache.values()){

            protected Concept convert(InMemoryConcept concept) {
                return concept;
            }
        };
    }

    public Concept getEntityConcept() {
        return this.conceptsCache.get("http://www.w3.org/2002/07/owl#Thing");
    }

    public Concept getParentConcept(Concept concept) {
        for (String key : this.conceptsCache.keySet()) {
            if (!key.equals(concept.getParentConceptIRI())) continue;
            return this.conceptsCache.get(key);
        }
        return null;
    }

    protected List<Concept> getChildConcepts(Concept concept) {
        ArrayList<Concept> results = new ArrayList<Concept>();
        for (Concept concept2 : this.conceptsCache.values()) {
            if (!concept.getIRI().equals(concept2.getParentConceptIRI())) continue;
            results.add(concept2);
        }
        return results;
    }

    protected List<Relationship> getChildRelationships(Relationship relationship) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship relationship2 : this.relationshipsCache.values()) {
            if (!relationship.getIRI().equals(relationship2.getParentIRI())) continue;
            results.add(relationship2);
        }
        return results;
    }

    public Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, File inDir) {
        return this.getOrCreateConcept(parent, conceptIRI, displayName, inDir, true);
    }

    public Concept getOrCreateConcept(Concept parent, String conceptIRI, String displayName, File inDir, boolean isDeclaredInOntology) {
        InMemoryConcept concept = (InMemoryConcept)this.getConceptByIRI(conceptIRI);
        if (concept != null) {
            return concept;
        }
        concept = parent == null ? new InMemoryConcept(conceptIRI, null) : new InMemoryConcept(conceptIRI, ((InMemoryConcept)parent).getConceptIRI());
        concept.setProperty(OntologyProperties.TITLE.getPropertyName(), conceptIRI, null);
        concept.setProperty(OntologyProperties.DISPLAY_NAME.getPropertyName(), displayName, null);
        this.conceptsCache.put(conceptIRI, concept);
        return concept;
    }

    public Relationship getOrCreateRelationshipType(Relationship parent, Iterable<Concept> domainConcepts, Iterable<Concept> rangeConcepts, String relationshipIRI) {
        Relationship relationship = this.getRelationshipByIRI(relationshipIRI);
        if (relationship != null) {
            return relationship;
        }
        List domainConceptIris = IterableUtils.toList((Iterable)new ConvertingIterable<Concept, String>(domainConcepts){

            protected String convert(Concept o) {
                return o.getIRI();
            }
        });
        List rangeConceptIris = IterableUtils.toList((Iterable)new ConvertingIterable<Concept, String>(rangeConcepts){

            protected String convert(Concept o) {
                return o.getIRI();
            }
        });
        String parentIRI = parent == null ? null : parent.getIRI();
        ArrayList<OntologyProperty> properties = new ArrayList<OntologyProperty>();
        InMemoryRelationship inMemRelationship = new InMemoryRelationship(parentIRI, relationshipIRI, domainConceptIris, rangeConceptIris, properties);
        this.relationshipsCache.put(relationshipIRI, inMemRelationship);
        return inMemRelationship;
    }

    protected Graph getGraph() {
        return this.graph;
    }

    private static class OwlData {
        public final String iri;
        public final byte[] data;

        public OwlData(String iri, byte[] data) {
            this.iri = iri;
            this.data = data;
        }
    }
}

