/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.user;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONObject;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.UserStatus;
import org.visallo.web.clientapi.model.UserType;

public class InMemoryUser
implements User {
    private final String userId;
    private final String userName;
    private final String displayName;
    private final String emailAddress;
    private final Date createDate;
    private final String currentWorkspaceId;
    private JSONObject preferences;
    private Date currentLoginDate;
    private String currentLoginRemoteAddr;
    private Date previousLoginDate;
    private String previousLoginRemoteAddr;
    private int loginCount;
    private String passwordResetToken;
    private Date passwordResetTokenExpirationDate;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public InMemoryUser(String userName, String displayName, String emailAddress, String currentWorkspaceId) {
        this.userId = UUID.randomUUID().toString();
        this.userName = userName;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.createDate = new Date();
        this.currentWorkspaceId = currentWorkspaceId;
        this.preferences = new JSONObject();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.userName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getCurrentLoginDate() {
        return this.currentLoginDate;
    }

    public String getCurrentLoginRemoteAddr() {
        return this.currentLoginRemoteAddr;
    }

    public Date getPreviousLoginDate() {
        return this.previousLoginDate;
    }

    public String getPreviousLoginRemoteAddr() {
        return this.previousLoginRemoteAddr;
    }

    public int getLoginCount() {
        return this.loginCount;
    }

    public UserType getUserType() {
        return UserType.USER;
    }

    public UserStatus getUserStatus() {
        throw new RuntimeException("not implemented");
    }

    public String getCurrentWorkspaceId() {
        return this.currentWorkspaceId;
    }

    public JSONObject getUiPreferences() {
        return this.preferences;
    }

    public void setPreferences(JSONObject preferences) {
        this.preferences = preferences;
    }

    public String getPasswordResetToken() {
        return this.passwordResetToken;
    }

    public Date getPasswordResetTokenExpirationDate() {
        return this.passwordResetTokenExpirationDate;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Map<String, Object> getCustomProperties() {
        return ImmutableMap.copyOf(this.properties);
    }

    public void setProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryUser that = (InMemoryUser)o;
        return this.userId.equals(that.userId);
    }

    public int hashCode() {
        return this.userId.hashCode();
    }

    public String toString() {
        return "InMemoryUser{userId='" + this.userId + '\'' + '}';
    }
}

