/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.vertexium.model.user;

import com.google.common.collect.Iterables;
import com.v5analytics.simpleorm.SimpleOrmSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.json.JSONObject;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.user.AuthorizationContext;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.vertexium.model.user.InMemoryUser;
import org.visallo.web.clientapi.model.UserStatus;

public class InMemoryUserRepository
extends UserRepository {
    private List<User> users = new ArrayList<User>();

    @Inject
    public InMemoryUserRepository(Configuration configuration, SimpleOrmSession simpleOrmSession, UserSessionCounterRepository userSessionCounterRepository, WorkQueueRepository workQueueRepository, LockRepository lockRepository, AuthorizationRepository authorizationRepository, PrivilegeRepository privilegeRepository) {
        super(configuration, simpleOrmSession, userSessionCounterRepository, workQueueRepository, lockRepository, authorizationRepository, privilegeRepository);
    }

    public User findByUsername(String username) {
        return (User)Iterables.find(this.users, user -> user.getUsername().equals(username), null);
    }

    public Iterable<User> find(int skip, int limit) {
        throw new RuntimeException("Not implemented");
    }

    public User findById(String userId) {
        return (User)Iterables.find(this.users, user -> user.getUserId().equals(userId), null);
    }

    protected User addUser(String username, String displayName, String emailAddress, String password) {
        username = this.formatUsername(username);
        displayName = displayName.trim();
        InMemoryUser user = new InMemoryUser(username, displayName, emailAddress, null);
        this.afterNewUserAdded(user);
        this.users.add(user);
        return user;
    }

    public void setPassword(User user, byte[] salt, byte[] passwordHash) {
        throw new RuntimeException("Not implemented");
    }

    public boolean isPasswordValid(User user, String password) {
        throw new RuntimeException("Not implemented");
    }

    public void updateUser(User user, AuthorizationContext authorizationContext) {
        throw new RuntimeException("Not implemented");
    }

    public User setCurrentWorkspace(String userId, String workspaceId) {
        throw new RuntimeException("Not implemented");
    }

    public String getCurrentWorkspaceId(String userId) {
        throw new RuntimeException("Not implemented");
    }

    public void setUiPreferences(User user, JSONObject preferences) {
        throw new RuntimeException("Not implemented");
    }

    public User setStatus(String userId, UserStatus status) {
        throw new RuntimeException("Not implemented");
    }

    public void setDisplayName(User user, String displayName) {
        throw new RuntimeException("Not implemented");
    }

    public void setEmailAddress(User user, String emailAddress) {
        throw new RuntimeException("Not implemented");
    }

    protected void internalDelete(User user) {
    }

    public User findByPasswordResetToken(String token) {
        throw new RuntimeException("Not implemented");
    }

    public void setPasswordResetTokenAndExpirationDate(User user, String token, Date expirationDate) {
        throw new RuntimeException("Not implemented");
    }

    public void clearPasswordResetTokenAndExpirationDate(User user) {
        throw new RuntimeException("Not implemented");
    }

    public void setPropertyOnUser(User user, String propertyName, Object value) {
        if (user instanceof SystemUser) {
            throw new VisalloException("Cannot set properties on system user");
        }
        ((InMemoryUser)user).setProperty(propertyName, value);
    }
}

