/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.web.SessionUser;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class VisalloBaseParameterProviderTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private UserRepository userRepository;
    @Mock
    private HttpSession session;

    @Before
    public void before() {
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.request.getSession(false)).thenReturn((Object)this.session);
    }

    @Test
    public void testGetUserWhenSetInRequestAlready() {
        ProxyUser user = new ProxyUser("user123", this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        User foundUser = VisalloBaseParameterProvider.getUser((HttpServletRequest)this.request, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)user, (Object)foundUser);
    }

    @Test
    public void testGetUserWhenSetInSession() {
        SessionUser sessionUser = new SessionUser("user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)sessionUser);
        User foundUser = VisalloBaseParameterProvider.getUser((HttpServletRequest)this.request, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)"user123", (Object)foundUser.getUserId());
    }

    @Test
    public void testGetUSerWhenNotSet() {
        User foundUser = VisalloBaseParameterProvider.getUser((HttpServletRequest)this.request, (UserRepository)this.userRepository);
        Assert.assertNull((String)"user should be null", (Object)foundUser);
    }
}

