/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.vertexium.Authorizations;
import org.vertexium.inmemory.InMemoryAuthorizations;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.web.parameterProviders.AuthorizationsParameterProviderFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class AuthorizationsParameterProviderFactoryTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private UserRepository userRepository;
    @Mock
    private AuthorizationRepository authorizationRepository;
    @Mock
    private WorkspaceRepository workspaceRepository;
    private ProxyUser proxyUser;

    @Before
    public void before() {
        this.proxyUser = new ProxyUser("user123", this.userRepository);
    }

    @Test
    public void testGetAuthorizations() {
        InMemoryAuthorizations authorizations = new InMemoryAuthorizations(new String[]{"a", "b", "workspace123"});
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"workspaceId"))).thenReturn((Object)"workspace123");
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"user"))).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)Matchers.eq((Object)this.proxyUser), new String[]{(String)Matchers.eq((Object)"workspace123")})).thenReturn((Object)authorizations);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"workspace123"), (User)Matchers.eq((Object)this.proxyUser))).thenReturn((Object)true);
        Authorizations auth = AuthorizationsParameterProviderFactory.getAuthorizations((HttpServletRequest)this.request, (UserRepository)this.userRepository, (AuthorizationRepository)this.authorizationRepository, (WorkspaceRepository)this.workspaceRepository);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "workspace123"}, (Object[])auth.getAuthorizations());
    }

    @Test
    public void testGetAuthorizationsNoWorkspaceAccess() {
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"workspaceId"))).thenReturn((Object)"workspace123");
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"user"))).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"workspace123"), (User)Matchers.eq((Object)this.proxyUser))).thenReturn((Object)false);
        try {
            AuthorizationsParameterProviderFactory.getAuthorizations((HttpServletRequest)this.request, (UserRepository)this.userRepository, (AuthorizationRepository)this.authorizationRepository, (WorkspaceRepository)this.workspaceRepository);
            TestCase.fail((String)"expected exception");
        }
        catch (VisalloAccessDeniedException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("workspace123"));
        }
    }

    @Test
    public void testGetAuthorizationsNoWorkspace() {
        InMemoryAuthorizations authorizations = new InMemoryAuthorizations(new String[]{"a", "b"});
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"workspaceId"))).thenReturn(null);
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"user"))).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)Matchers.eq((Object)this.proxyUser), new String[0])).thenReturn((Object)authorizations);
        Authorizations auth = AuthorizationsParameterProviderFactory.getAuthorizations((HttpServletRequest)this.request, (UserRepository)this.userRepository, (AuthorizationRepository)this.authorizationRepository, (WorkspaceRepository)this.workspaceRepository);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])auth.getAuthorizations());
    }

    @Test
    public void testGetAuthorizationsNoUser() {
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"user"))).thenReturn(null);
        Authorizations auth = AuthorizationsParameterProviderFactory.getAuthorizations((HttpServletRequest)this.request, (UserRepository)this.userRepository, (AuthorizationRepository)this.authorizationRepository, (WorkspaceRepository)this.workspaceRepository);
        Assert.assertNull((String)"expected null authorizations", (Object)auth);
        ((AuthorizationRepository)Mockito.verify((Object)this.authorizationRepository, (VerificationMode)Mockito.never())).getGraphAuthorizations((User)Mockito.any(), new String[0]);
        ((AuthorizationRepository)Mockito.verify((Object)this.authorizationRepository, (VerificationMode)Mockito.never())).getGraphAuthorizations((User)Mockito.any(), (String[])Mockito.any());
    }
}

