/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes;

import java.io.IOException;
import java.util.ResourceBundle;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.web.BadRequestException;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.routes.RouteTestBase;

public abstract class SetPropertyVisibilityTestBase
extends RouteTestBase {
    protected Authorizations authorizations;

    @Before
    public void before() throws IOException {
        super.before();
        this.graphRepository = (GraphRepository)Mockito.mock(GraphRepository.class);
        this.authorizations = this.graph.createAuthorizations(new String[]{"A"});
    }

    public abstract void testValid() throws Exception;

    protected void testValid(Element element) throws Exception {
        String newVisibilitySource = new VisibilityJson("A").getSource();
        String oldVisibilitySource = new VisibilityJson("").getSource();
        this.handle(element.getId(), newVisibilitySource, oldVisibilitySource, "k1", "p1", "WORKSPACE_12345", this.resourceBundle, this.user, this.authorizations);
        ((GraphRepository)Mockito.verify((Object)this.graphRepository)).updatePropertyVisibilitySource((Element)Matchers.eq((Object)element), (String)Matchers.eq((Object)"k1"), (String)Matchers.eq((Object)"p1"), (String)Matchers.eq((Object)""), (String)Matchers.eq((Object)"A"), (String)Matchers.eq((Object)"WORKSPACE_12345"), (User)Matchers.eq((Object)this.user), (Authorizations)Matchers.eq((Object)this.authorizations));
    }

    @Test
    public void testNotFound() throws Exception {
        String newVisibilitySource = new VisibilityJson("A").getSource();
        String oldVisibilitySource = new VisibilityJson("").getSource();
        Authorizations authorizations = this.graph.createAuthorizations(new String[0]);
        try {
            this.handle("badElementId", newVisibilitySource, oldVisibilitySource, "k1", "p1", "WORKSPACE_12345", this.resourceBundle, this.user, authorizations);
            TestCase.fail((String)"expected exception");
        }
        catch (VisalloResourceNotFoundException ex) {
            Assert.assertEquals((Object)"badElementId", (Object)ex.getResourceId());
        }
    }

    public abstract void testBadVisibility() throws Exception;

    protected void testBadVisibility(Element element) throws Exception {
        String newVisibilitySource = new VisibilityJson("bad").getSource();
        String oldVisibilitySource = new VisibilityJson("").getSource();
        try {
            this.handle(element.getId(), newVisibilitySource, oldVisibilitySource, "k1", "p1", "WORKSPACE_12345", this.resourceBundle, this.user, this.authorizations);
            TestCase.fail((String)"expected exception");
        }
        catch (BadRequestException ex) {
            Assert.assertEquals((Object)"newVisibilitySource", (Object)ex.getParameterName());
        }
    }

    protected abstract void handle(String var1, String var2, String var3, String var4, String var5, String var6, ResourceBundle var7, ProxyUser var8, Authorizations var9) throws Exception;
}

