/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ontology;

import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.WorkspaceAccess;
import org.visallo.web.routes.ontology.OntologyConceptSave;
import org.visallo.web.routes.ontology.OntologyRouteTestBase;

@RunWith(value=MockitoJUnitRunner.class)
public class OntologyConceptSaveTest
extends OntologyRouteTestBase {
    private OntologyConceptSave route;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.route = new OntologyConceptSave(this.ontologyRepository, this.workQueueRepository);
    }

    @Test
    public void testSaveNewConcept() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String conceptIri = "new-concept-iri";
        String displayName = "New Concept";
        ClientApiOntology.Concept response = this.route.handle(displayName, conceptIri, this.ontologyRepository.getEntityConcept("public-ontology").getIRI(), "glyph.png", "red", "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)conceptIri, (Object)response.getId());
        Assert.assertEquals((Object)this.ontologyRepository.getEntityConcept("public-ontology").getIRI(), (Object)response.getParentConcept());
        Assert.assertEquals((Object)displayName, (Object)response.getDisplayName());
        Assert.assertEquals((Object)"resource?id=new-concept-iri", (Object)response.getGlyphIconHref());
        Assert.assertEquals((Object)"red", (Object)response.getColor());
        Assert.assertEquals((Object)SandboxStatus.PRIVATE, (Object)response.getSandboxStatus());
        Concept concept = this.ontologyRepository.getConceptByIRI(conceptIri, "WORKSPACE_12345");
        Assert.assertNotNull((Object)concept);
        Assert.assertEquals((Object)"New Concept", (Object)concept.getDisplayName());
        Assert.assertEquals((Object)SandboxStatus.PRIVATE, (Object)concept.getSandboxStatus());
        Assert.assertEquals((Object)this.ontologyRepository.getEntityConcept("public-ontology").getIRI(), (Object)this.ontologyRepository.getParentConcept(concept, "WORKSPACE_12345").getIRI());
        Assert.assertNull((Object)this.ontologyRepository.getConceptByIRI(conceptIri, "public-ontology"));
        ((WorkQueueRepository)Mockito.verify((Object)this.workQueueRepository, (VerificationMode)Mockito.times((int)1))).pushOntologyConceptsChange("WORKSPACE_12345", new String[]{concept.getId()});
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testSaveNewConceptNoPermission() throws Exception {
        this.route.handle("New Concept", "new-concept-iri", this.ontologyRepository.getEntityConcept("public-ontology").getIRI(), "glyph.png", "red", "WORKSPACE_12345", (User)this.user);
    }

    @Test
    public void testSaveNewConceptWithUnknownParentConcept() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        try {
            this.route.handle("New Concept", "new-concept-iri", "unknown-parent-iri", "glyph.png", "red", "WORKSPACE_12345", (User)this.user);
            Assert.fail((String)"Expected to get an exception for unknown parent concept");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to find parent concept with IRI: unknown-parent-iri", (Object)ve.getMessage());
        }
    }

    @Test
    public void testSaveNewConceptWithGeneratedIriAndNoParent() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String displayName = "New Concept";
        String glyph = "glyph.png";
        String color = "red";
        ClientApiOntology.Concept response = this.route.handle(displayName, null, null, glyph, color, "WORKSPACE_12345", (User)this.user);
        String originalIri = response.getTitle();
        Assert.assertTrue((boolean)originalIri.matches("http://visallo.org/new_concept#[a-z0-9]+"));
    }

    @Test
    public void testSaveNewConceptWithGeneratedIri() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String thingIri = this.ontologyRepository.getEntityConcept("public-ontology").getIRI();
        String displayName = "New Concept";
        String glyph = "glyph.png";
        String color = "red";
        ClientApiOntology.Concept response = this.route.handle(displayName, null, thingIri, glyph, color, "WORKSPACE_12345", (User)this.user);
        String originalIri = response.getTitle();
        Assert.assertTrue((boolean)originalIri.matches("http://visallo.org/new_concept#[a-z0-9]+"));
        response = this.route.handle(displayName, null, thingIri, glyph, color, "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)originalIri, (Object)response.getTitle());
        response = this.route.handle(displayName, null, thingIri, "other.png", "orange", "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)originalIri, (Object)response.getTitle());
        response = this.route.handle(displayName + "1", null, thingIri, "other.png", "orange", "WORKSPACE_12345", (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_concept1#[a-z0-9]+"));
        response = this.route.handle(displayName, null, "public-concept-a", "other.png", "orange", "WORKSPACE_12345", (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_concept#[a-z0-9]+"));
        WorkspaceUser workspaceUser = new WorkspaceUser(this.user.getUserId(), WorkspaceAccess.WRITE, true);
        Mockito.when((Object)this.workspaceRepository.findUsersWithAccess("other-workspace", (User)this.user)).thenReturn(Collections.singletonList(workspaceUser));
        response = this.route.handle(displayName, null, thingIri, "other.png", "orange", "other-workspace", (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_concept#[a-z0-9]+"));
    }
}

