/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ontology;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.PropertyType;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.WorkspaceAccess;
import org.visallo.web.routes.ontology.OntologyPropertySave;
import org.visallo.web.routes.ontology.OntologyRouteTestBase;

@RunWith(value=MockitoJUnitRunner.class)
public class OntologyPropertySaveTest
extends OntologyRouteTestBase {
    private OntologyPropertySave route;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.route = new OntologyPropertySave(this.ontologyRepository, this.workQueueRepository);
    }

    @Test
    public void testSaveNewProperty() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String propertyIRI = "junit-property";
        ClientApiOntology.Property response = this.route.handle("New Property", "string", null, propertyIRI, new String[]{"public-concept-a"}, new String[]{"public-relationship"}, "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)propertyIRI, (Object)response.getTitle());
        Assert.assertEquals((Object)"New Property", (Object)response.getDisplayName());
        Assert.assertEquals((Object)PropertyType.STRING, (Object)response.getDataType());
        Assert.assertEquals(new TreeSet<String>(Arrays.asList("EXACT_MATCH", "FULL_TEXT")), new TreeSet(response.getTextIndexHints()));
        Assert.assertEquals((Object)SandboxStatus.PRIVATE, (Object)response.getSandboxStatus());
        OntologyProperty property = this.ontologyRepository.getPropertyByIRI(propertyIRI, "WORKSPACE_12345");
        Assert.assertNotNull((Object)property);
        Assert.assertEquals((Object)"New Property", (Object)property.getDisplayName());
        Assert.assertEquals((Object)SandboxStatus.PRIVATE, (Object)property.getSandboxStatus());
        Concept publicConcept = this.ontologyRepository.getConceptByIRI("public-concept-a", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicConcept.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        Relationship publicRelationship = this.ontologyRepository.getRelationshipByIRI("public-relationship", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicRelationship.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        Assert.assertNull((Object)this.ontologyRepository.getPropertyByIRI(propertyIRI, "public-ontology"));
        ((WorkQueueRepository)Mockito.verify((Object)this.workQueueRepository, (VerificationMode)Mockito.times((int)1))).pushOntologyChange("WORKSPACE_12345", Collections.singletonList(this.ontologyRepository.getConceptByIRI("public-concept-a", "WORKSPACE_12345").getId()), Collections.singletonList(this.ontologyRepository.getRelationshipByIRI("public-relationship", "WORKSPACE_12345").getId()), Collections.singletonList(property.getId()));
    }

    @Test
    public void testSaveNewPropertyWithDisplayType() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String propertyIRI = "junit-property";
        ClientApiOntology.Property response = this.route.handle("New Property", "integer", "bytes", propertyIRI, new String[]{"public-concept-a"}, new String[]{"public-relationship"}, "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)propertyIRI, (Object)response.getTitle());
        Assert.assertEquals((Object)"New Property", (Object)response.getDisplayName());
        Assert.assertEquals((Object)PropertyType.INTEGER, (Object)response.getDataType());
        Assert.assertEquals((Object)"bytes", (Object)response.getDisplayType());
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testSaveNewPropertyWithNoPrivilege() throws Exception {
        this.route.handle("New Property", "string", null, "junit-property", new String[]{"public-concept-a"}, new String[]{"public-relationship"}, "WORKSPACE_12345", (User)this.user);
    }

    @Test
    public void testSaveNewPropertyWithUnknownConcept() throws Exception {
        try {
            this.route.handle("New Property", "string", null, "junit-property", new String[]{"unknown-concept"}, new String[]{"public-relationship"}, "WORKSPACE_12345", (User)this.user);
            Assert.fail((String)"Expected to raise a VisalloException for unknown concept iri.");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load concept with IRI: unknown-concept", (Object)ve.getMessage());
        }
    }

    @Test
    public void testSaveNewPropertyWithUnknownRelationship() throws Exception {
        try {
            this.route.handle("New Property", "string", null, "junit-property", new String[]{"public-concept-a"}, new String[]{"unknown-relationship"}, "WORKSPACE_12345", (User)this.user);
            Assert.fail((String)"Expected to raise a VisalloException for unknown relationship iri.");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load relationship with IRI: unknown-relationship", (Object)ve.getMessage());
        }
    }

    @Test
    public void testSaveNewPropertyWithUnknownPropertyType() throws Exception {
        try {
            this.route.handle("New Property", "unknown-type", null, "junit-property", new String[]{"public-concept-a"}, new String[]{"public-relationship"}, "WORKSPACE_12345", (User)this.user);
            Assert.fail((String)"Expected to raise a VisalloException for unknown property type.");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unknown property type: unknown-type", (Object)ve.getMessage());
        }
    }

    @Test
    public void testAddAdditionalConceptAndRelationshipToNewProperty() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String propertyIRI = "junit-property";
        String displayName = "New Property";
        String dataType = "string";
        this.route.handle(displayName, dataType, null, propertyIRI, new String[]{"public-concept-a"}, new String[]{"public-relationship"}, "WORKSPACE_12345", (User)this.user);
        Concept publicConcept = this.ontologyRepository.getConceptByIRI("public-concept-a", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicConcept.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        Relationship publicRelationship = this.ontologyRepository.getRelationshipByIRI("public-relationship", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicRelationship.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        this.route.handle(displayName, dataType, null, propertyIRI, new String[]{"public-concept-b"}, new String[]{"public-relationship-b"}, "WORKSPACE_12345", (User)this.user);
        publicConcept = this.ontologyRepository.getConceptByIRI("public-concept-a", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicConcept.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        publicConcept = this.ontologyRepository.getConceptByIRI("public-concept-b", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicConcept.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        publicRelationship = this.ontologyRepository.getRelationshipByIRI("public-relationship", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicRelationship.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
        publicRelationship = this.ontologyRepository.getRelationshipByIRI("public-relationship-b", "WORKSPACE_12345");
        Assert.assertTrue((boolean)publicRelationship.getProperties().stream().anyMatch(p -> p.getIri().equals(propertyIRI)));
    }

    @Test
    public void testSaveNewPropertyWithGeneratedIri() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String displayName = "New Property";
        String dataType = "string";
        String[] things = new String[]{this.ontologyRepository.getEntityConcept("public-ontology").getIRI()};
        String[] relationships = new String[]{"public-relationship"};
        ClientApiOntology.Property response = this.route.handle(displayName, dataType, null, null, things, relationships, "WORKSPACE_12345", (User)this.user);
        String originalIri = response.getTitle();
        Assert.assertTrue((boolean)originalIri.matches("http://visallo.org/new_property#[a-z0-9]+"));
        response = this.route.handle(displayName + "1", dataType, null, null, things, relationships, "WORKSPACE_12345", (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_property1#[a-z0-9]+"));
        response = this.route.handle(displayName, "integer", null, null, things, relationships, "WORKSPACE_12345", (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_property#[a-z0-9]+"));
        response = this.route.handle(displayName, dataType, null, null, new String[]{"public-concept-a"}, relationships, "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)originalIri, (Object)response.getTitle());
        response = this.route.handle(displayName, dataType, null, null, things, new String[]{"public-relationship-b"}, "WORKSPACE_12345", (User)this.user);
        Assert.assertEquals((Object)originalIri, (Object)response.getTitle());
        WorkspaceUser workspaceUser = new WorkspaceUser(this.user.getUserId(), WorkspaceAccess.WRITE, true);
        Mockito.when((Object)this.workspaceRepository.findUsersWithAccess("other-workspace", (User)this.user)).thenReturn(Collections.singletonList(workspaceUser));
        response = this.route.handle(displayName, dataType, null, null, things, relationships, "other-workspace", (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_property#[a-z0-9]+"));
    }
}

