/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ontology;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.mockito.Mock;
import org.vertexium.Authorizations;
import org.visallo.core.cache.CacheService;
import org.visallo.core.cache.NopCacheService;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.model.lock.NonLockingLockRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.model.user.InMemoryGraphAuthorizationRepository;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.vertexium.model.ontology.VertexiumOntologyRepository;
import org.visallo.web.clientapi.model.PropertyType;
import org.visallo.web.routes.RouteTestBase;

public abstract class OntologyRouteTestBase
extends RouteTestBase {
    static final String PUBLIC_CONCEPT_IRI = "public-concept-a";
    static final String PUBLIC_CONCEPT_IRI_B = "public-concept-b";
    static final String PUBLIC_RELATIONSHIP_IRI = "public-relationship";
    static final String PUBLIC_RELATIONSHIP_IRI_B = "public-relationship-b";
    static final String PUBLIC_PROPERTY_IRI = "public-property";
    @Mock
    PrivilegeRepository privilegeRepository;
    Authorizations workspaceAuthorizations;

    @Before
    public void before() throws IOException {
        super.before();
        NonLockingLockRepository nonLockingLockRepository = new NonLockingLockRepository();
        InMemoryGraphAuthorizationRepository graphAuthorizationRepository = new InMemoryGraphAuthorizationRepository();
        try {
            this.ontologyRepository = new VertexiumOntologyRepository(this.graph, this.graphRepository, this.visibilityTranslator, this.configuration, (GraphAuthorizationRepository)graphAuthorizationRepository, (LockRepository)nonLockingLockRepository, (CacheService)new NopCacheService()){

                public void loadOntologies(Configuration config, Authorizations authorizations) throws Exception {
                    SystemUser systemUser = new SystemUser();
                    Concept rootConcept = this.getOrCreateConcept(null, "http://visallo.org#root", "root", null, (User)systemUser, "public-ontology");
                    this.getOrCreateConcept(rootConcept, "http://www.w3.org/2002/07/owl#Thing", "thing", null, (User)systemUser, "public-ontology");
                    this.getOrCreateConcept(null, "http://visallo.org/user#user", "visalloUser", null, false, (User)systemUser, "public-ontology");
                    this.defineRequiredProperties(this.getGraph());
                    this.clearCache();
                }

                protected PrivilegeRepository getPrivilegeRepository() {
                    return OntologyRouteTestBase.this.privilegeRepository;
                }

                protected WorkspaceRepository getWorkspaceRepository() {
                    return OntologyRouteTestBase.this.workspaceRepository;
                }
            };
        }
        catch (Exception e) {
            throw new VisalloException("Unable to create in ontology repository", (Throwable)e);
        }
        SystemUser systemUser = new SystemUser();
        Authorizations systemAuthorizations = this.graph.createAuthorizations(new String[]{"visallo"});
        Concept thingConcept = this.ontologyRepository.getEntityConcept("public-ontology");
        List<Concept> things = Collections.singletonList(thingConcept);
        Relationship hasEntityRel = this.ontologyRepository.getOrCreateRelationshipType(null, things, things, "has-entity-iri", true, (User)systemUser, "public-ontology");
        hasEntityRel.addIntent("entityHasImage", (User)this.user, systemAuthorizations);
        this.ontologyRepository.getOrCreateConcept(thingConcept, PUBLIC_CONCEPT_IRI, "Public A", null, (User)systemUser, "public-ontology");
        this.ontologyRepository.getOrCreateConcept(thingConcept, PUBLIC_CONCEPT_IRI_B, "Public B", null, (User)systemUser, "public-ontology");
        this.ontologyRepository.getOrCreateRelationshipType(null, things, things, PUBLIC_RELATIONSHIP_IRI, true, (User)systemUser, "public-ontology");
        this.ontologyRepository.getOrCreateRelationshipType(null, things, things, PUBLIC_RELATIONSHIP_IRI_B, true, (User)systemUser, "public-ontology");
        OntologyPropertyDefinition ontologyPropertyDefinition = new OntologyPropertyDefinition(things, PUBLIC_PROPERTY_IRI, "Public Property", PropertyType.DATE);
        this.ontologyRepository.getOrCreateProperty(ontologyPropertyDefinition, (User)systemUser, "public-ontology");
        this.ontologyRepository.clearCache();
        this.workspaceAuthorizations = this.graph.createAuthorizations(new String[]{"WORKSPACE_12345"});
    }
}

