/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ontology;

import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.ontology.Ontology;

@RunWith(value=MockitoJUnitRunner.class)
public class OntologyTest
extends RouteTestBase {
    private static final String ETAG = "12345";
    private Ontology route;
    private ClientApiOntology expectedClientApiOntology;
    @Mock
    private VisalloResponse visalloResponse;

    @Before
    public void before() throws IOException {
        super.before();
        this.route = new Ontology(this.ontologyRepository);
        this.expectedClientApiOntology = new ClientApiOntology();
        ClientApiOntology.Concept concept = new ClientApiOntology.Concept();
        concept.setId("concept-iri");
        this.expectedClientApiOntology.addAllConcepts(Collections.singleton(concept));
        ClientApiOntology.Relationship relationship = new ClientApiOntology.Relationship();
        relationship.setTitle("relationship-iri");
        this.expectedClientApiOntology.addAllRelationships(Collections.singleton(relationship));
        ClientApiOntology.Property property = new ClientApiOntology.Property();
        property.setTitle("property-iri");
        this.expectedClientApiOntology.addAllProperties(Collections.singleton(property));
        Mockito.when((Object)this.ontologyRepository.getClientApiObject("WORKSPACE_12345")).thenReturn((Object)this.expectedClientApiOntology);
        Mockito.when((Object)this.visalloResponse.generateETag((byte[])Matchers.notNull())).thenReturn((Object)ETAG);
    }

    @Test
    public void testWithNonMatchingEtagHeader() throws Exception {
        Mockito.when((Object)this.visalloResponse.testEtagHeaders(ETAG)).thenReturn((Object)false);
        ClientApiOntology clientOntology = this.route.handle("WORKSPACE_12345", this.visalloResponse);
        Assert.assertSame((Object)this.expectedClientApiOntology, (Object)clientOntology);
        ((VisalloResponse)Mockito.verify((Object)this.visalloResponse, (VerificationMode)Mockito.times((int)1))).addETagHeader(ETAG);
    }

    @Test
    public void testWithMatchingEtagHeader() throws Exception {
        Mockito.when((Object)this.visalloResponse.testEtagHeaders(ETAG)).thenReturn((Object)true);
        ClientApiOntology clientOntology = this.route.handle("WORKSPACE_12345", this.visalloResponse);
        Assert.assertSame((Object)this.expectedClientApiOntology, (Object)clientOntology);
        ((VisalloResponse)Mockito.verify((Object)this.visalloResponse, (VerificationMode)Mockito.never())).addETagHeader(ETAG);
    }
}

