/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.search;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.search.SearchRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiSearch;
import org.visallo.web.routes.search.SearchDelete;

@RunWith(value=MockitoJUnitRunner.class)
public class SearchDeleteTest {
    private SearchDelete searchDelete;
    @Mock
    private SearchRepository searchRepository;
    @Mock
    private User user;

    @Before
    public void setUp() {
        this.searchDelete = new SearchDelete(this.searchRepository);
    }

    @Test
    public void testDeleteExists() throws Exception {
        String id = "1234";
        ClientApiSearch savedSearch = new ClientApiSearch();
        Mockito.when((Object)this.searchRepository.getSavedSearch((String)Matchers.eq((Object)id), (User)Matchers.eq((Object)this.user))).thenReturn((Object)savedSearch);
        this.searchDelete.handle(id, this.user);
        ((SearchRepository)Mockito.verify((Object)this.searchRepository)).deleteSearch(id, this.user);
    }

    @Test
    public void testDeleteNotExists() throws Exception {
        String id = "1234";
        Mockito.when((Object)this.searchRepository.getSavedSearch((String)Matchers.eq((Object)id), (User)Matchers.eq((Object)this.user))).thenReturn(null);
        try {
            this.searchDelete.handle(id, this.user);
            throw new VisalloException("Should have thrown not found");
        }
        catch (VisalloResourceNotFoundException visalloResourceNotFoundException) {
            return;
        }
    }
}

